/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u0013\tq1\t[3dWB|\u0017N\u001c;GS2,'BA\u0002\u0005\u0003-\u0019\u0007.Z2la>Lg\u000e^:\u000b\u0005\u00151\u0011AB:feZ,'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"AC\u0019\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)\u0019\tQ!\u001e;jYNL!AF\n\u0003\u000f1{wmZ5oO\"A\u0001\u0004\u0001BC\u0002\u0013\u0005\u0011$\u0001\u0003gS2,W#\u0001\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012AA5p\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\t\u0019KG.\u001a\u0005\tG\u0001\u0011\t\u0011)A\u00055\u0005)a-\u001b7fA!AQ\u0005\u0001B\u0001B\u0003%a%A\u0004wKJ\u001c\u0018n\u001c8\u0011\u000519\u0013B\u0001\u0015\u000e\u0005\rIe\u000e\u001e\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005Iam\u001c:nCR$XM\u001d\t\u0004Y5zS\"\u0001\u0002\n\u00059\u0012!aF\"iK\u000e\\\u0007o\\5oi\u001aKG.\u001a$pe6\fG\u000f^3s!\t\u0001\u0014\u0007\u0004\u0001\u0005\u000bI\u0002!\u0019A\u001a\u0003\u0003Q\u000b\"\u0001N\u001c\u0011\u00051)\u0014B\u0001\u001c\u000e\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0004\u001d\n\u0005ej!aA!os\")1\b\u0001C\u0001y\u00051A(\u001b8jiz\"B!\u0010 @\u0001B\u0019A\u0006A\u0018\t\u000baQ\u0004\u0019\u0001\u000e\t\u000b\u0015R\u0004\u0019\u0001\u0014\t\u000b)R\u0004\u0019A\u0016\t\u000f\t\u0003!\u0019!C\u0005\u0007\u0006!\u0001/\u0019;i+\u0005!\u0005CA#J\u001b\u00051%B\u0001\rH\u0015\tAe$A\u0002oS>L!A\u0013$\u0003\tA\u000bG\u000f\u001b\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002#\u0002\u000bA\fG\u000f\u001b\u0011\t\u000f9\u0003!\u0019!C\u0005\u0007\u0006AA/Z7q!\u0006$\b\u000e\u0003\u0004Q\u0001\u0001\u0006I\u0001R\u0001\ni\u0016l\u0007\u000fU1uQ\u0002BqA\u0015\u0001C\u0002\u0013%1+\u0001\u0003m_\u000e\\W#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]s\u0012\u0001\u00027b]\u001eL!!\u0017,\u0003\r=\u0013'.Z2u\u0011\u0019Y\u0006\u0001)A\u0005)\u0006)An\\2lA!)Q\f\u0001C\u0001=\u0006)qO]5uKR\u0011qL\u0019\t\u0003\u0019\u0001L!!Y\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006Gr\u0003\r\u0001Z\u0001\bK:$(/[3t!\r)\u0007nL\u0007\u0002M*\u0011q-D\u0001\u000bG>dG.Z2uS>t\u0017BA5g\u0005\r\u0019V-\u001d\u0005\u0006W\u0002!\t\u0001\\\u0001\u0005e\u0016\fG\rF\u0001e\u0001")
public class CheckpointFile<T>
implements Logging {
    private final File file;
    private final int version;
    public final CheckpointFileFormatter<T> kafka$server$checkpoints$CheckpointFile$$formatter;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        CheckpointFile checkpointFile = this;
        synchronized (checkpointFile) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Seq<T> entries) {
        Object object = this.lock();
        synchronized (object) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath().toFile());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));
            this.liftedTree1$1(entries, fileOutputStream, writer);
            Utils.atomicMoveWithFallback((Path)this.tempPath(), (Path)this.path());
            return;
        }
    }

    public Seq<T> read() {
        NonLocalReturnControl nonLocalReturnControl2;
        block6: {
            Seq seq;
            Object object = new Object();
            try {
                Object object2 = this.lock();
                synchronized (object2) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file()), StandardCharsets.UTF_8));
                    ObjectRef line = ObjectRef.create(null);
                    Seq seq2 = this.liftedTree2$1(reader, line, object);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
                    seq = seq2;
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block6;
                seq = (Seq)nonLocalReturnControl2.value();
            }
            return seq;
        }
        throw nonLocalReturnControl2;
    }

    private final void liftedTree1$1(Seq entries$1, FileOutputStream fileOutputStream$1, BufferedWriter writer$1) {
        try {
            writer$1.write(((Object)BoxesRunTime.boxToInteger((int)this.version)).toString());
            writer$1.newLine();
            writer$1.write(((Object)BoxesRunTime.boxToInteger((int)entries$1.size())).toString());
            writer$1.newLine();
            entries$1.foreach((Function1)new Serializable(this, writer$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CheckpointFile $outer;
                private final BufferedWriter writer$1;

                public final void apply(T entry2) {
                    this.writer$1.write(this.$outer.kafka$server$checkpoints$CheckpointFile$$formatter.toLine(entry2));
                    this.writer$1.newLine();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.writer$1 = writer$1;
                }
            });
            writer$1.flush();
            fileOutputStream$1.getFD().sync();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (FileSystems.getDefault().isReadOnly()) {
                this.fatal((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CheckpointFile $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Halting writes to checkpoint file (", ") because the underlying file system is inaccessible: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function0<Throwable>)new Serializable(this, fileNotFoundException){
                    public static final long serialVersionUID = 0L;
                    private final FileNotFoundException e$1;

                    public final FileNotFoundException apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
            }
            throw fileNotFoundException;
        }
        finally {
            writer$1.close();
        }
    }

    private final IOException malformedLineException$1(String line) {
        return new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed line in checkpoint file (", "): ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), line})));
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq liftedTree2$1(BufferedReader reader$1, ObjectRef line$1, Object nonLocalReturnKey1$1) {
        try {
            line$1.elem = reader$1.readLine();
            if ((String)line$1.elem == null) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Seq$.MODULE$.empty());
            }
            int n = new StringOps(Predef$.MODULE$.augmentString((String)line$1.elem)).toInt();
            switch (n) {
                default: 
            }
            if (n != this.version) throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized version of the checkpoint file (", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()}))).append((Object)BoxesRunTime.boxToInteger((int)this.version)).toString());
            line$1.elem = reader$1.readLine();
            if ((String)line$1.elem == null) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Seq$.MODULE$.empty());
            }
            int expectedSize = new StringOps(Predef$.MODULE$.augmentString((String)line$1.elem)).toInt();
            Buffer entries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            line$1.elem = reader$1.readLine();
            while (true) {
                void var7_6;
                Option<T> entry2;
                if ((String)line$1.elem == null) {
                    if (entries.size() == expectedSize) return entries;
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " entries in checkpoint file (", "), but found only ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedSize), this.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)entries.size())})));
                }
                Option<T> option = entry2 = this.kafka$server$checkpoints$CheckpointFile$$formatter.fromLine((String)line$1.elem);
                if (!(option instanceof Some)) throw this.malformedLineException$1((String)line$1.elem);
                Some some = (Some)option;
                Object e = some.x();
                var7_6.$plus$eq(e);
                line$1.elem = reader$1.readLine();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                continue;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.malformedLineException$1((String)line$1.elem);
            }
        }
        finally {
            reader$1.close();
        }
    }

    public CheckpointFile(File file, int version, CheckpointFileFormatter<T> formatter) {
        Object object;
        this.file = file;
        this.version = version;
        this.kafka$server$checkpoints$CheckpointFile$$formatter = formatter;
        Logging$class.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder().append((Object)((Object)this.path()).toString()).append((Object)".tmp").toString(), new String[0]);
        this.lock = new Object();
        try {
            object = Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            object = BoxedUnit.UNIT;
        }
    }
}

