/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.hive.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.schema.HiveSchemaFactory;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDatabaseSchema
extends AbstractSchema {
    static final Logger logger = LoggerFactory.getLogger(HiveDatabaseSchema.class);
    private final HiveSchemaFactory.HiveSchema hiveSchema;
    private Set<String> tables;
    private final DrillHiveMetaStoreClient mClient;
    private final SchemaConfig schemaConfig;

    public HiveDatabaseSchema(HiveSchemaFactory.HiveSchema hiveSchema, String name, DrillHiveMetaStoreClient mClient, SchemaConfig schemaConfig) {
        super(hiveSchema.getSchemaPath(), name);
        this.hiveSchema = hiveSchema;
        this.mClient = mClient;
        this.schemaConfig = schemaConfig;
    }

    public org.apache.calcite.schema.Table getTable(String tableName) {
        return this.hiveSchema.getDrillTable(this.name, tableName);
    }

    public Set<String> getTableNames() {
        if (this.tables == null) {
            try {
                this.tables = Sets.newHashSet(this.mClient.getTableNames(this.name, this.schemaConfig.getIgnoreAuthErrors()));
            }
            catch (TException e) {
                logger.warn("Failure while attempting to access HiveDatabase '{}'.", (Object)this.name, (Object)e.getCause());
                this.tables = Sets.newHashSet();
            }
        }
        return this.tables;
    }

    public String getTypeName() {
        return "hive";
    }

    public List<Pair<String, ? extends org.apache.calcite.schema.Table>> getTablesByNamesByBulkLoad(List<String> tableNames, int bulkSize) {
        String schemaName = this.getName();
        List<Table> tables = DrillHiveMetaStoreClient.getTablesByNamesByBulkLoadHelper(this.mClient, tableNames, schemaName, bulkSize);
        ArrayList tableNameToTable = Lists.newArrayList();
        for (Table table : tables) {
            if (table == null) continue;
            String tableName = table.getTableName();
            Schema.TableType tableType = table.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) ? Schema.TableType.VIEW : Schema.TableType.TABLE;
            tableNameToTable.add(Pair.of((Object)tableName, (Object)new HiveTableWithoutStatisticAndRowType(tableType)));
        }
        return tableNameToTable;
    }

    private static class HiveTableWithoutStatisticAndRowType
    implements org.apache.calcite.schema.Table {
        private final Schema.TableType tableType;

        public HiveTableWithoutStatisticAndRowType(Schema.TableType tableType) {
            this.tableType = tableType;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            throw new UnsupportedOperationException("RowType was not retrieved when this table had been being requested");
        }

        public Statistic getStatistic() {
            throw new UnsupportedOperationException("Statistic was not retrieved when this table had been being requested");
        }

        public Schema.TableType getJdbcTableType() {
            return this.tableType;
        }
    }
}

