/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers.initilializers;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.readers.HiveAbstractReader;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class AbstractReadersInitializer {
    protected final HiveSubScan config;
    private final FragmentContext context;
    private final Class<? extends HiveAbstractReader> readerClass;
    private final UserGroupInformation proxyUgi;

    public AbstractReadersInitializer(FragmentContext context, HiveSubScan config, Class<? extends HiveAbstractReader> readerClass) {
        this.config = config;
        this.context = context;
        this.readerClass = readerClass;
        this.proxyUgi = ImpersonationUtil.createProxyUgi((String)config.getUserName(), (String)context.getQueryUserName());
    }

    protected Constructor<? extends HiveAbstractReader> createReaderConstructor() {
        try {
            return this.readerClass.getConstructor(HiveTableWithColumnCache.class, HivePartition.class, Collection.class, List.class, FragmentContext.class, HiveConf.class, UserGroupInformation.class);
        }
        catch (ReflectiveOperationException e) {
            throw new DrillRuntimeException(String.format("Unable to retrieve constructor for Hive reader class [%s]", this.readerClass), (Throwable)e);
        }
    }

    protected HiveAbstractReader createReader(Constructor<? extends HiveAbstractReader> readerConstructor, Partition partition, Object split) {
        try {
            return readerConstructor.newInstance(new Object[]{this.config.getTable(), partition, split, this.config.getColumns(), this.context, this.config.getHiveConf(), this.proxyUgi});
        }
        catch (ReflectiveOperationException e) {
            throw new DrillRuntimeException(String.format("Unable to create instance for Hive reader [%s]", readerConstructor), (Throwable)e);
        }
    }

    public abstract List<RecordReader> init();
}

