/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.hive.readers.HiveAbstractReader;
import org.apache.drill.exec.store.hive.readers.inspectors.AbstractRecordsInspector;
import org.apache.drill.exec.store.hive.readers.inspectors.DefaultRecordsInspector;
import org.apache.drill.exec.store.hive.readers.inspectors.SkipFooterRecordsInspector;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveTextReader
extends HiveAbstractReader {
    AbstractRecordsInspector recordsInspector;

    public HiveTextReader(HiveTableWithColumnCache table, HivePartition partition, Collection<InputSplit> inputSplit, List<SchemaPath> projectedColumns, FragmentContext context, HiveConf hiveConf, UserGroupInformation proxyUgi) throws ExecutionSetupException {
        super(table, partition, inputSplit, projectedColumns, context, hiveConf, proxyUgi);
    }

    @Override
    public void internalInit(Properties tableProperties, RecordReader<Object, Object> reader) {
        this.key = reader.createKey();
        int skipHeaderCount = HiveUtilities.retrieveIntProperty(tableProperties, "skip.header.line.count", -1);
        Object value = reader.createValue();
        for (int i = 0; i < skipHeaderCount; ++i) {
            if (this.hasNextValue(value)) continue;
            this.empty = true;
            break;
        }
        if (!this.empty) {
            int skipFooterCount = HiveUtilities.retrieveIntProperty(tableProperties, "skip.footer.line.count", -1);
            this.recordsInspector = skipFooterCount > 0 ? new SkipFooterRecordsInspector(reader, skipFooterCount) : new DefaultRecordsInspector(reader.createValue());
        }
    }

    @Override
    public int next() {
        for (ValueVector vv : this.vectors) {
            AllocationHelper.allocateNew((ValueVector)vv, (int)4000);
        }
        if (this.empty) {
            this.setValueCountAndPopulatePartitionVectors(0);
            return 0;
        }
        try {
            this.recordsInspector.reset();
            while (!this.recordsInspector.isBatchFull() && this.hasNextValue(this.recordsInspector.getValueHolder())) {
                Object value = this.recordsInspector.getNextValue();
                if (value == null) continue;
                Object deSerializedValue = this.partitionSerDe.deserialize((Writable)value);
                if (this.partTblObjectInspectorConverter != null) {
                    deSerializedValue = this.partTblObjectInspectorConverter.convert(deSerializedValue);
                }
                this.readHiveRecordAndInsertIntoRecordBatch(deSerializedValue, this.recordsInspector.getProcessedRecordCount());
                this.recordsInspector.incrementProcessedRecordCount();
            }
            this.setValueCountAndPopulatePartitionVectors(this.recordsInspector.getProcessedRecordCount());
            return this.recordsInspector.getProcessedRecordCount();
        }
        catch (SerDeException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }
}

