/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.sql.logical.ConvertHiveParquetScanToDrillParquetScan;
import org.apache.drill.exec.planner.sql.logical.HivePushPartitionFilterIntoScan;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveStoragePluginConfig;
import org.apache.drill.exec.store.hive.schema.HiveSchemaFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStoragePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(HiveStoragePlugin.class);
    private final HiveStoragePluginConfig config;
    private HiveSchemaFactory schemaFactory;
    private final HiveConf hiveConf;

    public HiveStoragePlugin(HiveStoragePluginConfig config, DrillbitContext context, String name) throws ExecutionSetupException {
        super(context, name);
        this.config = config;
        this.hiveConf = HiveStoragePlugin.createHiveConf(config.getHiveConfigOverride());
        this.schemaFactory = new HiveSchemaFactory(this, name, this.hiveConf);
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public HiveStoragePluginConfig getConfig() {
        return this.config;
    }

    public HiveScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) throws IOException {
        HiveReadEntry hiveReadEntry = (HiveReadEntry)selection.getListWith(new ObjectMapper(), (TypeReference)new TypeReference<HiveReadEntry>(){});
        try {
            if (hiveReadEntry.getJdbcTableType() == Schema.TableType.VIEW) {
                throw new UnsupportedOperationException("Querying views created in Hive from Drill is not supported in current version.");
            }
            return new HiveScan(userName, hiveReadEntry, this, columns, null);
        }
        catch (ExecutionSetupException e) {
            throw new IOException(e);
        }
    }

    public synchronized void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        try {
            this.schemaFactory.registerSchemas(schemaConfig, parent);
            return;
        }
        catch (Throwable e) {
            Throwable ex = e;
            while (!(ex instanceof MetaException) && !(ex instanceof TTransportException)) {
                if (ex.getCause() == null || ex.getCause() == ex) {
                    logger.error("Hive metastore register schemas failed", e);
                    throw new DrillRuntimeException("Unknown Hive error", e);
                }
                ex = ex.getCause();
            }
            try {
                this.schemaFactory.close();
            }
            catch (Throwable t) {
                logger.warn("Schema factory forced close failed, error ignored", t);
            }
            try {
                this.schemaFactory = new HiveSchemaFactory(this, this.getName(), this.hiveConf);
            }
            catch (ExecutionSetupException e2) {
                throw new DrillRuntimeException((Throwable)e2);
            }
            this.schemaFactory.registerSchemas(schemaConfig, parent);
            logger.debug("Successfully recovered from a Hive metastore connection failure.");
            return;
        }
    }

    public Set<StoragePluginOptimizerRule> getLogicalOptimizerRules(OptimizerRulesContext optimizerContext) {
        String defaultPartitionValue = this.hiveConf.get(HiveConf.ConfVars.DEFAULTPARTITIONNAME.varname);
        ImmutableSet.Builder ruleBuilder = ImmutableSet.builder();
        ruleBuilder.add((Object)HivePushPartitionFilterIntoScan.getFilterOnProject(optimizerContext, defaultPartitionValue));
        ruleBuilder.add((Object)HivePushPartitionFilterIntoScan.getFilterOnScan(optimizerContext, defaultPartitionValue));
        return ruleBuilder.build();
    }

    public Set<StoragePluginOptimizerRule> getPhysicalOptimizerRules(OptimizerRulesContext optimizerRulesContext) {
        if (optimizerRulesContext.getPlannerSettings().getOptions().getOption((String)"store.hive.optimize_scan_with_native_readers").bool_val.booleanValue()) {
            return ImmutableSet.of((Object)((Object)ConvertHiveParquetScanToDrillParquetScan.INSTANCE));
        }
        return ImmutableSet.of();
    }

    private static HiveConf createHiveConf(Map<String, String> hiveConfigOverride) {
        HiveConf hiveConf = new HiveConf();
        for (Map.Entry<String, String> config : hiveConfigOverride.entrySet()) {
            String key = config.getKey();
            String value = config.getValue();
            hiveConf.set(key, value);
            logger.trace("HiveConfig Override {}={}", (Object)key, (Object)value);
        }
        return hiveConf;
    }
}

