/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.ColumnListsCache;
import org.apache.drill.exec.store.hive.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveTableWrapper;
import org.apache.drill.exec.util.Utilities;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hive-scan")
public class HiveScan
extends AbstractGroupScan {
    private static final Logger logger = LoggerFactory.getLogger(HiveScan.class);
    private static int HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN = 20;
    @JsonProperty(value="hive-table")
    public HiveReadEntry hiveReadEntry;
    @JsonIgnore
    public HiveStoragePlugin storagePlugin;
    @JsonProperty(value="columns")
    public List<SchemaPath> columns;
    @JsonIgnore
    protected final HiveMetadataProvider metadataProvider;
    @JsonIgnore
    private List<List<HiveMetadataProvider.LogicalInputSplit>> mappings;
    @JsonIgnore
    protected List<HiveMetadataProvider.LogicalInputSplit> inputSplits;

    @JsonCreator
    public HiveScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="hive-table") HiveReadEntry hiveReadEntry, @JsonProperty(value="storage-plugin") String storagePluginName, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        this(userName, hiveReadEntry, (HiveStoragePlugin)pluginRegistry.getPlugin(storagePluginName), columns, null);
    }

    public HiveScan(String userName, HiveReadEntry hiveReadEntry, HiveStoragePlugin storagePlugin, List<SchemaPath> columns, HiveMetadataProvider metadataProvider) throws ExecutionSetupException {
        super(userName);
        this.hiveReadEntry = hiveReadEntry;
        this.columns = columns;
        this.storagePlugin = storagePlugin;
        this.metadataProvider = metadataProvider == null ? new HiveMetadataProvider(userName, hiveReadEntry, storagePlugin.getHiveConf()) : metadataProvider;
    }

    public HiveScan(HiveScan that) {
        super((AbstractGroupScan)that);
        this.columns = that.columns;
        this.hiveReadEntry = that.hiveReadEntry;
        this.storagePlugin = that.storagePlugin;
        this.metadataProvider = that.metadataProvider;
    }

    public HiveScan clone(HiveReadEntry hiveReadEntry) throws ExecutionSetupException {
        return new HiveScan(this.getUserName(), hiveReadEntry, this.storagePlugin, this.columns, this.metadataProvider);
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    protected List<HiveMetadataProvider.LogicalInputSplit> getInputSplits() {
        if (this.inputSplits == null) {
            this.inputSplits = this.metadataProvider.getInputSplits(this.hiveReadEntry);
        }
        return this.inputSplits;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.mappings = new ArrayList<List<HiveMetadataProvider.LogicalInputSplit>>();
        for (int i = 0; i < endpoints.size(); ++i) {
            this.mappings.add(new ArrayList());
        }
        int count = endpoints.size();
        List<HiveMetadataProvider.LogicalInputSplit> inputSplits = this.getInputSplits();
        for (int i = 0; i < inputSplits.size(); ++i) {
            this.mappings.get(i % count).add(inputSplits.get(i));
        }
    }

    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        try {
            List<HiveMetadataProvider.LogicalInputSplit> splits = this.mappings.get(minorFragmentId);
            ArrayList parts = Lists.newArrayList();
            ArrayList encodedInputSplits = Lists.newArrayList();
            ArrayList splitTypes = Lists.newArrayList();
            for (HiveMetadataProvider.LogicalInputSplit split : splits) {
                Partition splitPartition = split.getPartition();
                if (splitPartition != null) {
                    HiveTableWithColumnCache table = this.hiveReadEntry.getTable();
                    parts.add(DrillHiveMetaStoreClient.createPartitionWithSpecColumns(new HiveTableWithColumnCache(table, new ColumnListsCache(table)), splitPartition));
                }
                encodedInputSplits.add(split.serialize());
                splitTypes.add(split.getType());
            }
            if (parts.size() <= 0) {
                parts = null;
            }
            HiveReadEntry subEntry = new HiveReadEntry(this.hiveReadEntry.getTableWrapper(), parts);
            return new HiveSubScan(this.getUserName(), encodedInputSplits, subEntry, splitTypes, this.columns, this.storagePlugin);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int getMaxParallelizationWidth() {
        return this.getInputSplits().size();
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        HashMap<String, CoordinationProtos.DrillbitEndpoint> endpointMap = new HashMap<String, CoordinationProtos.DrillbitEndpoint>();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.storagePlugin.getContext().getBits()) {
            endpointMap.put(endpoint.getAddress(), endpoint);
            logger.debug("endpoing address: {}", (Object)endpoint.getAddress());
        }
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = new HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity>();
        try {
            long totalSize = 0L;
            List<HiveMetadataProvider.LogicalInputSplit> inputSplits = this.getInputSplits();
            for (HiveMetadataProvider.LogicalInputSplit split : inputSplits) {
                totalSize += Math.max(1L, split.getLength());
            }
            for (HiveMetadataProvider.LogicalInputSplit split : inputSplits) {
                float affinity = (float)Math.max(1L, split.getLength()) / (float)totalSize;
                for (String loc : split.getLocations()) {
                    logger.debug("split location: {}", (Object)loc);
                    CoordinationProtos.DrillbitEndpoint endpoint = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(loc);
                    if (endpoint == null) continue;
                    if (affinityMap.containsKey(endpoint)) {
                        ((EndpointAffinity)affinityMap.get(endpoint)).addAffinity((double)affinity);
                        continue;
                    }
                    affinityMap.put(endpoint, new EndpointAffinity(endpoint, (double)affinity));
                }
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
        for (CoordinationProtos.DrillbitEndpoint ep : affinityMap.keySet()) {
            Preconditions.checkNotNull((Object)ep);
        }
        for (EndpointAffinity a : affinityMap.values()) {
            Preconditions.checkNotNull((Object)a.getEndpoint());
        }
        return Lists.newArrayList(affinityMap.values());
    }

    public ScanStats getScanStats() {
        try {
            HiveMetadataProvider.HiveStats stats = this.metadataProvider.getStats(this.hiveReadEntry);
            logger.debug("HiveStats: {}", (Object)stats.toString());
            float cpuCost = 1 * this.getSerDeOverheadFactor();
            return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)stats.getNumRows(), (double)cpuCost, (double)stats.getSizeInBytes());
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    protected int getSerDeOverheadFactor() {
        int projectedColumnCount;
        if (Utilities.isStarQuery(this.columns)) {
            HiveTableWithColumnCache hiveTable = this.hiveReadEntry.getTable();
            projectedColumnCount = hiveTable.getSd().getColsSize() + hiveTable.getPartitionKeysSize();
        } else {
            projectedColumnCount = Math.max(this.columns.size(), 1);
        }
        return projectedColumnCount * HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new HiveScan(this);
    }

    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        List<HiveTableWrapper.HivePartitionWrapper> partitions = this.hiveReadEntry.getHivePartitionWrappers();
        int numPartitions = partitions == null ? 0 : partitions.size();
        return "HiveScan [table=" + this.hiveReadEntry.getHiveTableWrapper() + ", columns=" + this.columns + ", numPartitions=" + numPartitions + ", partitions= " + partitions + ", inputDirectories=" + this.metadataProvider.getInputDirectories(this.hiveReadEntry) + "]";
    }

    public GroupScan clone(List<SchemaPath> columns) {
        HiveScan newScan = new HiveScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public boolean supportsPartitionFilterPushdown() {
        List partitionKeys = this.hiveReadEntry.getTable().getPartitionKeys();
        return partitionKeys != null && partitionKeys.size() != 0;
    }

    @JsonIgnore
    public HiveConf getHiveConf() {
        return this.storagePlugin.getHiveConf();
    }

    @JsonIgnore
    public boolean isNativeReader() {
        return false;
    }
}

