/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.hive.HiveDrillNativeParquetSubScan;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.readers.HiveDefaultReader;
import org.apache.drill.exec.store.parquet.ParquetDirectByteBufferAllocator;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.util.Utilities;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;

public class HiveDrillNativeScanBatchCreator
implements BatchCreator<HiveDrillNativeParquetSubScan> {
    public ScanBatch getBatch(FragmentContext context, HiveDrillNativeParquetSubScan config, List<RecordBatch> children) throws ExecutionSetupException {
        HiveTableWithColumnCache table = config.getTable();
        List<List<InputSplit>> splits = config.getInputSplits();
        List<HivePartition> partitions = config.getPartitions();
        ArrayList columns = config.getColumns();
        String partitionDesignator = context.getOptions().getOption((String)"drill.exec.storage.file.partition.column.label").string_val;
        LinkedList implicitColumns = Lists.newLinkedList();
        boolean selectAllQuery = Utilities.isStarQuery(columns);
        boolean hasPartitions = partitions != null && partitions.size() > 0;
        ArrayList partitionColumns = Lists.newArrayList();
        ArrayList selectedPartitionColumns = Lists.newArrayList();
        ArrayList newColumns = columns;
        if (!selectAllQuery) {
            newColumns = Lists.newArrayList();
            Pattern pattern = Pattern.compile(String.format("%s[0-9]+", partitionDesignator));
            for (SchemaPath column : columns) {
                Matcher m = pattern.matcher(column.getRootSegmentPath());
                if (m.matches()) {
                    selectedPartitionColumns.add(Integer.parseInt(column.getRootSegmentPath().substring(partitionDesignator.length())));
                    continue;
                }
                newColumns.add(column);
            }
        }
        OperatorContext oContext = context.newOperatorContext((PhysicalOperator)config);
        int currentPartitionIndex = 0;
        ArrayList readers = Lists.newArrayList();
        HiveConf conf = config.getHiveConf();
        HashMap footerCache = Maps.newHashMap();
        Map mapWithMaxColumns = Maps.newLinkedHashMap();
        try {
            for (List<InputSplit> splitGroups : splits) {
                for (InputSplit split : splitGroups) {
                    FileSplit fileSplit = (FileSplit)split;
                    Path finalPath = fileSplit.getPath();
                    JobConf cloneJob = new ProjectionPusher().pushProjectionsAndFilters(new JobConf((Configuration)conf), finalPath.getParent());
                    FileSystem fs = finalPath.getFileSystem((Configuration)cloneJob);
                    ParquetMetadata parquetMetadata = (ParquetMetadata)footerCache.get(finalPath.toString());
                    if (parquetMetadata == null) {
                        parquetMetadata = ParquetFileReader.readFooter((Configuration)cloneJob, (Path)finalPath);
                        footerCache.put(finalPath.toString(), parquetMetadata);
                    }
                    List<Integer> rowGroupNums = this.getRowGroupNumbersFromFileSplit(fileSplit, parquetMetadata);
                    for (int rowGroupNum : rowGroupNums) {
                        if (((BlockMetaData)parquetMetadata.getBlocks().get(rowGroupNum)).getRowCount() == 0L) continue;
                        ParquetReaderUtility.DateCorruptionStatus containsCorruptDates = ParquetReaderUtility.detectCorruptDates((ParquetMetadata)parquetMetadata, config.getColumns(), (boolean)true);
                        if (logger.isDebugEnabled()) {
                            logger.debug(containsCorruptDates.toString());
                        }
                        readers.add(new ParquetRecordReader(context, Path.getPathWithoutSchemeAndAuthority((Path)finalPath).toString(), rowGroupNum, fs, CodecFactory.createDirectCodecFactory((Configuration)fs.getConf(), (ByteBufferAllocator)new ParquetDirectByteBufferAllocator(oContext.getAllocator()), (int)0), parquetMetadata, (List)newColumns, containsCorruptDates));
                        LinkedHashMap implicitValues = Maps.newLinkedHashMap();
                        if (hasPartitions) {
                            List values = partitions.get(currentPartitionIndex).getValues();
                            for (int i = 0; i < values.size(); ++i) {
                                if (!selectAllQuery && !selectedPartitionColumns.contains(i)) continue;
                                implicitValues.put(partitionDesignator + i, values.get(i));
                            }
                        }
                        implicitColumns.add(implicitValues);
                        if (implicitValues.size() <= mapWithMaxColumns.size()) continue;
                        mapWithMaxColumns = implicitValues;
                    }
                    ++currentPartitionIndex;
                }
            }
        }
        catch (IOException | RuntimeException e) {
            AutoCloseables.close((Throwable)e, (Collection)readers);
            throw new ExecutionSetupException("Failed to create RecordReaders. " + e.getMessage(), (Throwable)e);
        }
        mapWithMaxColumns = Maps.transformValues((Map)mapWithMaxColumns, (Function)Functions.constant((Object)null));
        for (Map map : implicitColumns) {
            map.putAll(Maps.difference((Map)map, (Map)mapWithMaxColumns).entriesOnlyOnRight());
        }
        if (readers.size() == 0) {
            readers.add(new HiveDefaultReader(table, null, null, columns, context, conf, ImpersonationUtil.createProxyUgi((String)config.getUserName(), (String)context.getQueryUserName())));
        }
        return new ScanBatch((PhysicalOperator)config, context, oContext, (List)readers, (List)implicitColumns);
    }

    private List<Integer> getRowGroupNumbersFromFileSplit(FileSplit split, ParquetMetadata footer) throws IOException {
        List blocks = footer.getBlocks();
        long splitStart = split.getStart();
        long splitLength = split.getLength();
        ArrayList rowGroupNums = Lists.newArrayList();
        int i = 0;
        for (BlockMetaData block : blocks) {
            long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
            if (firstDataPage >= splitStart && firstDataPage < splitStart + splitLength) {
                rowGroupNums.add(i);
            }
            ++i;
        }
        return rowGroupNums;
    }
}

