/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;

public class ColumnListsCache {
    private final List<List<FieldSchema>> fields = Lists.newArrayList();
    private final Map<List<FieldSchema>, Integer> keys = Maps.newHashMap();

    public ColumnListsCache(Table table) {
        this();
        this.addOrGet(table.getSd().getCols());
    }

    public ColumnListsCache() {
    }

    public int addOrGet(List<FieldSchema> columns) {
        if (columns == null) {
            return -1;
        }
        Integer index = this.keys.get(columns);
        if (index != null) {
            return index;
        }
        index = this.fields.size();
        ImmutableList immutableList = ImmutableList.copyOf(columns);
        this.fields.add((List<FieldSchema>)immutableList);
        this.keys.put((List<FieldSchema>)immutableList, index);
        return index;
    }

    public List<FieldSchema> getColumns(int index) {
        if (index >= 0 && index < this.fields.size()) {
            return this.fields.get(index);
        }
        return null;
    }

    public List<List<FieldSchema>> getFields() {
        return Lists.newArrayList(this.fields);
    }
}

