/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.hbase.BMCallable;
import com.mapr.fs.jni.MapRCallBackQueue;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.BufferedMutator;

public class BufferedMutatorCallBackQueue
implements MapRCallBackQueue {
    private final BufferedMutator bm_;
    private final BufferedMutator.ExceptionListener listener_;
    private List<Future<Boolean>> futureList_ = new LinkedList<Future<Boolean>>();
    private final MapRHTable mTable_;
    private final ExecutorService pool_;
    private static final Log LOG = LogFactory.getLog(BufferedMutatorCallBackQueue.class);

    public BufferedMutatorCallBackQueue(BufferedMutator bm, BufferedMutator.ExceptionListener listener, MapRHTable mTable, ExecutorService pool) throws IOException {
        if (listener != null && pool == null) {
            throw new IOException("No MapRClusterConnection provided to serve the callbacks for BufferedMutator Listener.");
        }
        this.bm_ = bm;
        this.listener_ = listener;
        this.mTable_ = mTable;
        this.pool_ = pool;
    }

    public void runCallbackChain(LinkedList<Object> requests, LinkedList<Object> responses) {
        if (this.listener_ == null) {
            return;
        }
        BMCallable bmr = new BMCallable(this.bm_, this.listener_, this.mTable_, requests, responses);
        Future<Boolean> future = this.pool_.submit(bmr);
        this.futureList_.add(future);
    }

    public void shutdown() throws IOException {
        int failedCount = 0;
        try {
            for (Future<Boolean> fut : this.futureList_) {
                if (fut.get() != Boolean.FALSE) continue;
                ++failedCount;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get BufferMutator Callback results. Reason:" + e.getStackTrace()));
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        if (failedCount > 0) {
            LOG.error((Object)("Failed to notify " + failedCount + " listeners"));
        }
    }
}

