/*
 * Decompiled with CFR 0.152.
 */
package com.madhukaraphatak.sizeof;

import com.madhukaraphatak.sizeof.SizeEstimator;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SizeEstimator$ {
    public static final SizeEstimator$ MODULE$;
    private final int BYTE_SIZE;
    private final int BOOLEAN_SIZE;
    private final int CHAR_SIZE;
    private final int SHORT_SIZE;
    private final int INT_SIZE;
    private final int LONG_SIZE;
    private final int FLOAT_SIZE;
    private final int DOUBLE_SIZE;
    private final int ALIGN_SIZE;
    private final ConcurrentHashMap<Class<?>, SizeEstimator.ClassInfo> classInfos;
    private boolean is64bit;
    private boolean isCompressedOops;
    private int com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize;
    private int objectSize;
    private final int ARRAY_SIZE_FOR_SAMPLING;
    private final int ARRAY_SAMPLE_SIZE;

    static {
        new SizeEstimator$();
    }

    private int BYTE_SIZE() {
        return this.BYTE_SIZE;
    }

    private int BOOLEAN_SIZE() {
        return this.BOOLEAN_SIZE;
    }

    private int CHAR_SIZE() {
        return this.CHAR_SIZE;
    }

    private int SHORT_SIZE() {
        return this.SHORT_SIZE;
    }

    private int INT_SIZE() {
        return this.INT_SIZE;
    }

    private int LONG_SIZE() {
        return this.LONG_SIZE;
    }

    private int FLOAT_SIZE() {
        return this.FLOAT_SIZE;
    }

    private int DOUBLE_SIZE() {
        return this.DOUBLE_SIZE;
    }

    private int ALIGN_SIZE() {
        return this.ALIGN_SIZE;
    }

    private ConcurrentHashMap<Class<?>, SizeEstimator.ClassInfo> classInfos() {
        return this.classInfos;
    }

    private boolean is64bit() {
        return this.is64bit;
    }

    private void is64bit_$eq(boolean x$1) {
        this.is64bit = x$1;
    }

    private boolean isCompressedOops() {
        return this.isCompressedOops;
    }

    private void isCompressedOops_$eq(boolean x$1) {
        this.isCompressedOops = x$1;
    }

    public int com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize() {
        return this.com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize;
    }

    private void com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize_$eq(int x$1) {
        this.com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize = x$1;
    }

    private int objectSize() {
        return this.objectSize;
    }

    private void objectSize_$eq(int x$1) {
        this.objectSize = x$1;
    }

    private void initialize() {
        this.is64bit_$eq(System.getProperty("os.arch").contains("64"));
        this.isCompressedOops_$eq(this.getIsCompressedOops());
        this.objectSize_$eq(this.is64bit() ? (this.isCompressedOops() ? 12 : 16) : 8);
        this.com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize_$eq(this.is64bit() && !this.isCompressedOops() ? 8 : 4);
        this.classInfos().clear();
        this.classInfos().put(Object.class, new SizeEstimator.ClassInfo(this.objectSize(), (List<Field>)Nil$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getIsCompressedOops() {
        if (System.getProperty("spark.test.useCompressedOops") != null) return new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.test.useCompressedOops"))).toBoolean();
        try {
            String hotSpotMBeanName = "com.sun.management:type=HotSpotDiagnostic";
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Class<?> hotSpotMBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method getVMMethod = hotSpotMBeanClass.getDeclaredMethod("getVMOption", Class.forName("java.lang.String"));
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, hotSpotMBeanName, hotSpotMBeanClass);
            return getVMMethod.invoke(bean, "UseCompressedOops").toString().contains("true");
        }
        catch (Exception exception) {
            if (Runtime.getRuntime().maxMemory() >= 0x800000000L) return false;
            return true;
        }
    }

    public long estimate(Object obj) {
        return this.com$madhukaraphatak$sizeof$SizeEstimator$$estimate(obj, new IdentityHashMap<Object, Object>());
    }

    /*
     * WARNING - void declaration
     */
    public long com$madhukaraphatak$sizeof$SizeEstimator$$estimate(Object obj, IdentityHashMap<Object, Object> visited) {
        SizeEstimator.SearchState state = new SizeEstimator.SearchState(visited);
        state.enqueue(obj);
        while (!state.isFinished()) {
            void var3_3;
            this.visitSingleObject(var3_3.dequeue(), (SizeEstimator.SearchState)var3_3);
        }
        return state.size();
    }

    private void visitSingleObject(Object obj, SizeEstimator.SearchState state) {
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            this.visitArray(obj, cls, state);
        } else if (!(obj instanceof ClassLoader) && !(obj instanceof Class)) {
            SizeEstimator.ClassInfo classInfo = this.getClassInfo(cls);
            state.size_$eq(state.size() + classInfo.shellSize());
            classInfo.pointerFields().foreach((Function1)new Serializable(obj, state){
                public static final long serialVersionUID = 0L;
                private final Object obj$1;
                private final SizeEstimator.SearchState state$1;

                public final void apply(Field field) {
                    this.state$1.enqueue(field.get(this.obj$1));
                }
                {
                    this.obj$1 = obj$1;
                    this.state$1 = state$1;
                }
            });
        }
    }

    private int ARRAY_SIZE_FOR_SAMPLING() {
        return this.ARRAY_SIZE_FOR_SAMPLING;
    }

    private int ARRAY_SAMPLE_SIZE() {
        return this.ARRAY_SAMPLE_SIZE;
    }

    private void visitArray(Object array, Class<?> cls, SizeEstimator.SearchState state) {
        int length = Array.getLength(array);
        Class<?> elementClass = cls.getComponentType();
        long arrSize = this.alignSize(this.objectSize() + this.INT_SIZE());
        if (elementClass.isPrimitive()) {
            state.size_$eq(state.size() + (arrSize += this.alignSize((long)length * this.com$madhukaraphatak$sizeof$SizeEstimator$$primitiveSize(elementClass))));
        } else {
            state.size_$eq(state.size() + (arrSize += this.alignSize(length * this.com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize())));
            if (length <= this.ARRAY_SIZE_FOR_SAMPLING()) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)new Serializable(array, state){
                    public static final long serialVersionUID = 0L;
                    private final Object array$1;
                    private final SizeEstimator.SearchState state$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.state$2.enqueue(Array.get(this.array$1, i));
                    }
                    {
                        this.array$1 = array$1;
                        this.state$2 = state$2;
                    }
                });
            } else {
                DoubleRef size = DoubleRef.create((double)0.0);
                Random rand = new Random(42L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ARRAY_SAMPLE_SIZE()).foreach$mVc$sp((Function1)new Serializable(array, state, length, size, rand){
                    public static final long serialVersionUID = 0L;
                    private final Object array$1;
                    private final SizeEstimator.SearchState state$2;
                    private final int length$1;
                    private final DoubleRef size$1;
                    private final Random rand$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Object elem = Array.get(this.array$1, this.rand$1.nextInt(this.length$1));
                        this.size$1.elem += (double)SizeEstimator$.MODULE$.com$madhukaraphatak$sizeof$SizeEstimator$$estimate(elem, this.state$2.visited());
                    }
                    {
                        this.array$1 = array$1;
                        this.state$2 = state$2;
                        this.length$1 = length$1;
                        this.size$1 = size$1;
                        this.rand$1 = rand$1;
                    }
                });
                state.size_$eq(state.size() + (long)((double)(length / this.ARRAY_SAMPLE_SIZE()) * 1.0 * size.elem));
            }
        }
    }

    public long com$madhukaraphatak$sizeof$SizeEstimator$$primitiveSize(Class<?> cls) {
        block10: {
            long l;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            Class<?> clazz = cls;
                                            Class<Byte> clazz2 = Byte.TYPE;
                                            if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block2;
                                            l = this.BYTE_SIZE();
                                            break block3;
                                        }
                                        Class<?> clazz = cls;
                                        Class<Boolean> clazz3 = Boolean.TYPE;
                                        if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block4;
                                        l = this.BOOLEAN_SIZE();
                                        break block3;
                                    }
                                    Class<?> clazz = cls;
                                    Class<Character> clazz4 = Character.TYPE;
                                    if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block5;
                                    l = this.CHAR_SIZE();
                                    break block3;
                                }
                                Class<?> clazz = cls;
                                Class<Short> clazz5 = Short.TYPE;
                                if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block6;
                                l = this.SHORT_SIZE();
                                break block3;
                            }
                            Class<?> clazz = cls;
                            Class<Integer> clazz6 = Integer.TYPE;
                            if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block7;
                            l = this.INT_SIZE();
                            break block3;
                        }
                        Class<?> clazz = cls;
                        Class<Long> clazz7 = Long.TYPE;
                        if (clazz != null ? !clazz.equals(clazz7) : clazz7 != null) break block8;
                        l = this.LONG_SIZE();
                        break block3;
                    }
                    Class<?> clazz = cls;
                    Class<Float> clazz8 = Float.TYPE;
                    if (clazz != null ? !clazz.equals(clazz8) : clazz8 != null) break block9;
                    l = this.FLOAT_SIZE();
                    break block3;
                }
                Class<?> clazz = cls;
                Class<Double> clazz9 = Double.TYPE;
                if (clazz != null ? !clazz.equals(clazz9) : clazz9 != null) break block10;
                l = this.DOUBLE_SIZE();
            }
            return l;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Non-primitive class ").append(cls).append((Object)" passed to primitiveSize()").toString());
    }

    /*
     * WARNING - void declaration
     */
    private SizeEstimator.ClassInfo getClassInfo(Class<?> cls) {
        void var2_2;
        SizeEstimator.ClassInfo info = this.classInfos().get(cls);
        if (info == null) {
            SizeEstimator.ClassInfo parent = this.getClassInfo(cls.getSuperclass());
            LongRef shellSize = LongRef.create((long)parent.shellSize());
            ObjectRef pointerFields = ObjectRef.create(parent.pointerFields());
            Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields()).foreach((Function1)new Serializable(shellSize, pointerFields){
                public static final long serialVersionUID = 0L;
                private final LongRef shellSize$1;
                private final ObjectRef pointerFields$1;

                public final void apply(Field field) {
                    if (!Modifier.isStatic(field.getModifiers())) {
                        Class<?> fieldClass = field.getType();
                        if (fieldClass.isPrimitive()) {
                            this.shellSize$1.elem += SizeEstimator$.MODULE$.com$madhukaraphatak$sizeof$SizeEstimator$$primitiveSize(fieldClass);
                        } else {
                            field.setAccessible(true);
                            this.shellSize$1.elem += (long)SizeEstimator$.MODULE$.com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize();
                            Field field2 = field;
                            this.pointerFields$1.elem = ((List)this.pointerFields$1.elem).$colon$colon((Object)field2);
                        }
                    }
                }
                {
                    this.shellSize$1 = shellSize$1;
                    this.pointerFields$1 = pointerFields$1;
                }
            });
            shellSize.elem = this.alignSize(shellSize.elem);
            SizeEstimator.ClassInfo newInfo = new SizeEstimator.ClassInfo(shellSize.elem, (List<Field>)((List)pointerFields.elem));
            this.classInfos().put(cls, newInfo);
            return newInfo;
        }
        return var2_2;
    }

    private long alignSize(long size) {
        long rem = size % (long)this.ALIGN_SIZE();
        return rem == 0L ? size : size + (long)this.ALIGN_SIZE() - rem;
    }

    private SizeEstimator$() {
        MODULE$ = this;
        this.BYTE_SIZE = 1;
        this.BOOLEAN_SIZE = 1;
        this.CHAR_SIZE = 2;
        this.SHORT_SIZE = 2;
        this.INT_SIZE = 4;
        this.LONG_SIZE = 8;
        this.FLOAT_SIZE = 4;
        this.DOUBLE_SIZE = 8;
        this.ALIGN_SIZE = 8;
        this.classInfos = new ConcurrentHashMap();
        this.is64bit = false;
        this.isCompressedOops = false;
        this.com$madhukaraphatak$sizeof$SizeEstimator$$pointerSize = 4;
        this.objectSize = 8;
        this.initialize();
        this.ARRAY_SIZE_FOR_SAMPLING = 200;
        this.ARRAY_SAMPLE_SIZE = 100;
    }
}

