/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.streaming;

import de.huxhorn.sulky.codec.Decoder;
import de.huxhorn.sulky.codec.streaming.StreamingDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoderBridge<E>
implements Decoder<E> {
    private final Logger logger = LoggerFactory.getLogger(DecoderBridge.class);
    private StreamingDecoder<E> wrapped;

    public DecoderBridge(StreamingDecoder<E> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public E decode(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            return this.wrapped.decode(bis);
        }
        catch (IOException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't decode!", (Throwable)e);
            }
            return null;
        }
    }
}

