/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.remote.TypedValue;

public class LocalService
implements Service {
    final Meta meta;

    public LocalService(Meta meta) {
        this.meta = meta;
    }

    private static <E> List<E> list(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> rowList = new ArrayList<E>();
        for (E row : iterable) {
            rowList.add(row);
        }
        return rowList;
    }

    public Service.ResultSetResponse toResponse(Meta.MetaResultSet resultSet) {
        if (resultSet.updateCount != -1L) {
            return new Service.ResultSetResponse(resultSet.connectionId, resultSet.statementId, resultSet.ownStatement, null, null, resultSet.updateCount);
        }
        Meta.CursorFactory cursorFactory = resultSet.signature.cursorFactory;
        if (resultSet.firstFrame != null) {
            List<Object> list = LocalService.list(resultSet.firstFrame.rows);
            switch (cursorFactory.style) {
                case ARRAY: {
                    cursorFactory = Meta.CursorFactory.LIST;
                    break;
                }
                case MAP: 
                case LIST: {
                    break;
                }
                default: {
                    cursorFactory = Meta.CursorFactory.map(cursorFactory.fieldNames);
                    break;
                }
            }
        } else {
            cursorFactory = Meta.CursorFactory.LIST;
        }
        Meta.Signature signature = resultSet.signature;
        if (cursorFactory != resultSet.signature.cursorFactory) {
            signature = signature.setCursorFactory(cursorFactory);
        }
        return new Service.ResultSetResponse(resultSet.connectionId, resultSet.statementId, resultSet.ownStatement, signature, resultSet.firstFrame, -1L);
    }

    private List<List<Object>> list2(Meta.MetaResultSet resultSet) {
        Meta.StatementHandle h = new Meta.StatementHandle(resultSet.connectionId, resultSet.statementId, null);
        List<TypedValue> parameterValues = Collections.emptyList();
        Iterable<Object> iterable = this.meta.createIterable(h, resultSet.signature, parameterValues, resultSet.firstFrame);
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        return MetaImpl.collect(resultSet.signature.cursorFactory, iterable, list);
    }

    @Override
    public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getCatalogs();
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.SchemasRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getSchemas(request.catalog, Meta.Pat.of(request.schemaPattern));
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TablesRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getTables(request.catalog, Meta.Pat.of(request.schemaPattern), Meta.Pat.of(request.tableNamePattern), request.typeList);
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TableTypesRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getTableTypes();
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.TypeInfoRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getTypeInfo();
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.ColumnsRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getColumns(request.catalog, Meta.Pat.of(request.schemaPattern), Meta.Pat.of(request.tableNamePattern), Meta.Pat.of(request.columnNamePattern));
        return this.toResponse(resultSet);
    }

    @Override
    public Service.PrepareResponse apply(Service.PrepareRequest request) {
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(request.connectionId);
        Meta.StatementHandle h = this.meta.prepare(ch, request.sql, request.maxRowCount);
        return new Service.PrepareResponse(h);
    }

    @Override
    public Service.ExecuteResponse apply(Service.PrepareAndExecuteRequest request) {
        Meta.StatementHandle sh = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        Meta.ExecuteResult executeResult = this.meta.prepareAndExecute(sh, request.sql, request.maxRowCount, new Meta.PrepareCallback(){

            @Override
            public Object getMonitor() {
                return LocalService.class;
            }

            @Override
            public void clear() {
            }

            @Override
            public void assign(Meta.Signature signature, Meta.Frame firstFrame, long updateCount) {
            }

            @Override
            public void execute() {
            }
        });
        ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>();
        for (Meta.MetaResultSet metaResultSet : executeResult.resultSets) {
            results.add(this.toResponse(metaResultSet));
        }
        return new Service.ExecuteResponse(results);
    }

    @Override
    public Service.FetchResponse apply(Service.FetchRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.connectionId, request.statementId, null);
        Meta.Frame frame = this.meta.fetch(h, request.parameterValues, request.offset, request.fetchMaxRowCount);
        return new Service.FetchResponse(frame);
    }

    @Override
    public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
        Meta.StatementHandle h = this.meta.createStatement(new Meta.ConnectionHandle(request.connectionId));
        return new Service.CreateStatementResponse(h.connectionId, h.id);
    }

    @Override
    public Service.CloseStatementResponse apply(Service.CloseStatementRequest request) {
        this.meta.closeStatement(new Meta.StatementHandle(request.connectionId, request.statementId, null));
        return new Service.CloseStatementResponse();
    }

    @Override
    public Service.CloseConnectionResponse apply(Service.CloseConnectionRequest request) {
        this.meta.closeConnection(new Meta.ConnectionHandle(request.connectionId));
        return new Service.CloseConnectionResponse();
    }

    @Override
    public Service.ConnectionSyncResponse apply(Service.ConnectionSyncRequest request) {
        Meta.ConnectionProperties connProps = this.meta.connectionSync(new Meta.ConnectionHandle(request.connectionId), request.connProps);
        return new Service.ConnectionSyncResponse(connProps);
    }

    @Override
    public Service.DatabasePropertyResponse apply(Service.DatabasePropertyRequest request) {
        return new Service.DatabasePropertyResponse(this.meta.getDatabaseProperties());
    }
}

