/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;

public class DoYUtil {
    private static final Log LOG = LogFactory.getLog(DoYUtil.class);

    private DoYUtil() {
    }

    public static String join(String separator, List<String> list) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (String item : list) {
            buf.append(sep);
            buf.append(item);
            sep = separator;
        }
        return buf.toString();
    }

    public static void addNonEmpty(List<String> list, String value) {
        if (!DoYUtil.isBlank(value)) {
            list.add(value.trim());
        }
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String toIsoTime(long timestamp) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        fmt.setTimeZone(TimeZone.getDefault());
        return fmt.format(new Date(timestamp));
    }

    public static String labelContainer(Container container) {
        StringBuilder buf = new StringBuilder().append("[id: ").append(container.getId()).append(", host: ").append(container.getNodeId().getHost()).append(", priority: ").append(container.getPriority()).append("]");
        return buf.toString();
    }

    public static String describeContainer(Container container) {
        StringBuilder buf = new StringBuilder().append("[id: ").append(container.getId()).append(", host: ").append(container.getNodeId().getHost()).append(", priority: ").append(container.getPriority()).append(", memory: ").append(container.getResource().getMemory()).append(" MB, vcores: ").append(container.getResource().getVirtualCores()).append("]");
        return buf.toString();
    }

    public static String unwrapAmUrl(String trackingUrl) {
        return trackingUrl.replace("/redirect", "/");
    }

    public static Object dynamicCall(Object target, String fnName, Object[] args, Class<?>[] types) {
        Method m;
        String methodLabel = target.getClass().getName() + "." + fnName;
        try {
            m = target.getClass().getMethod(fnName, types);
        }
        catch (NoSuchMethodException e) {
            StringBuilder buf = new StringBuilder();
            if (types != null) {
                String sep = "";
                for (Class<?> type : types) {
                    buf.append(sep);
                    buf.append(type.getName());
                    sep = ",";
                }
            }
            LOG.trace((Object)("Not supported in this YARN distribution: " + methodLabel + "(" + buf.toString() + ")"));
            CodeSource src = target.getClass().getProtectionDomain().getCodeSource();
            if (src != null) {
                URL jar = src.getLocation();
                LOG.trace((Object)("Class found in URL: " + jar.toString()));
            }
            return null;
        }
        catch (SecurityException e) {
            LOG.error((Object)"Security prevents dynamic method calls", (Throwable)e);
            return null;
        }
        Object ret = null;
        try {
            ret = m.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOG.error((Object)("Failed to dynamically call " + methodLabel), (Throwable)e);
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (args != null) {
            String sep = "";
            for (Object arg : args) {
                buf.append(sep);
                buf.append(arg == null ? "null" : arg.toString());
                sep = ",";
            }
        }
        LOG.trace((Object)("Successfully called " + methodLabel + "( " + buf.toString() + ")"));
        return ret;
    }

    public static void callSetDiskIfExists(Object target, double arg) {
        DoYUtil.dynamicCall(target, "setDisks", new Object[]{arg}, new Class[]{Double.TYPE});
    }

    public static double callGetDiskIfExists(Object target) {
        Object ret = DoYUtil.dynamicCall(target, "getDisks", null, null);
        return ret == null ? 0.0 : (Double)ret;
    }
}

