/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster.http;

import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.apache.drill.yarn.appMaster.Dispatcher;
import org.apache.drill.yarn.appMaster.http.AMSecurityManagerImpl;
import org.apache.drill.yarn.appMaster.http.AuthDynamicFeature;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.glassfish.jersey.server.ResourceConfig;

public class PageTree
extends ResourceConfig {
    static Dispatcher dispatcher;
    static Config config;

    public PageTree(Dispatcher dispatcher) {
        PageTree.dispatcher = dispatcher;
        config = DrillOnYarnConfig.config();
    }

    public static Map<String, Object> toModel(SecurityContext sc, Object base) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("model", base);
        return PageTree.toMapModel(sc, model);
    }

    public static Map<String, Object> toMapModel(SecurityContext sc, Map<String, Object> model) {
        model.put("clusterName", config.getString(DrillOnYarnConfig.APP_NAME));
        boolean useAuth = AMSecurityManagerImpl.isEnabled();
        boolean isUserLoggedIn = useAuth ? AuthDynamicFeature.isUserLoggedIn(sc) : false;
        model.put("showLogin", useAuth && !isUserLoggedIn);
        model.put("showLogout", isUserLoggedIn);
        model.put("docsLink", config.getString(DrillOnYarnConfig.HTTP_DOCS_LINK));
        String userName = isUserLoggedIn ? sc.getUserPrincipal().getName() : "anonymous";
        model.put("loggedInUserName", userName);
        return model;
    }
}

