/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.drill.yarn.appMaster.Dispatcher;
import org.apache.drill.yarn.appMaster.http.AbstractTasksModel;
import org.apache.drill.yarn.appMaster.http.ControllerModel;
import org.apache.drill.yarn.appMaster.http.PageTree;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.NameValuePair;
import org.apache.drill.yarn.zk.ZKClusterCoordinatorDriver;

public class AmRestApi
extends PageTree {
    private static Map<String, String> checkKey(String key) {
        String masterKey = DrillOnYarnConfig.config().getString(DrillOnYarnConfig.HTTP_REST_KEY);
        if (!DoYUtil.isBlank(masterKey) && !masterKey.equals(key)) {
            return AmRestApi.errorResponse("Invalid Key");
        }
        return null;
    }

    private static Map<String, String> errorResponse(String msg) {
        HashMap<String, String> resp = new HashMap<String, String>();
        resp.put("status", "error");
        resp.put("message", msg);
        return resp;
    }

    private static Map<String, String> successResponse(String msg) {
        HashMap<String, String> resp = new HashMap<String, String>();
        resp.put("status", "ok");
        resp.put("message", msg);
        return resp;
    }

    public AmRestApi(Dispatcher dispatcher) {
        super(dispatcher);
        this.register(ConfigResource.class);
        this.register(StatusResource.class);
        this.register(StopResource.class);
        this.register(ResizeResource.class);
        this.register(GrowResource.class);
        this.register(ShrinkResource.class);
    }

    @Path(value="/shrink/{quantity}")
    @PermitAll
    public static class ShrinkResource {
        @PathParam(value="quantity")
        @DefaultValue(value="1")
        String quantity;
        @DefaultValue(value="")
        @QueryParam(value="key")
        String key;

        @POST
        @Produces(value={"application/json"})
        public Map<String, String> postResize() {
            ResizeRequest request = new ResizeRequest(this.key, this.quantity);
            if (request.error != null) {
                return request.error;
            }
            int curSize = PageTree.dispatcher.getController().getTargetCount();
            int newSize = Math.max(curSize - request.n, 0);
            PageTree.dispatcher.getController().resizeTo(newSize);
            return AmRestApi.successResponse("Shrinking by " + request.n + " to " + newSize);
        }
    }

    @Path(value="/grow/{quantity}")
    @PermitAll
    public static class GrowResource {
        @PathParam(value="quantity")
        @DefaultValue(value="1")
        String quantity;
        @DefaultValue(value="")
        @QueryParam(value="key")
        String key;

        @POST
        @Produces(value={"application/json"})
        public Map<String, String> postResize() {
            ResizeRequest request = new ResizeRequest(this.key, this.quantity);
            if (request.error != null) {
                return request.error;
            }
            int curSize = PageTree.dispatcher.getController().getTargetCount();
            int newSize = curSize + request.n;
            PageTree.dispatcher.getController().resizeTo(newSize);
            return AmRestApi.successResponse("Growing by " + request.n + " to " + newSize);
        }
    }

    protected static class ResizeRequest {
        Map<String, String> error;
        int n;

        public ResizeRequest(String key, String quantity) {
            this.error = AmRestApi.checkKey(key);
            if (this.error != null) {
                return;
            }
            try {
                this.n = Integer.parseInt(quantity);
            }
            catch (NumberFormatException e) {
                this.error = AmRestApi.errorResponse("Invalid argument: " + quantity);
            }
            if (this.n < 0) {
                this.error = AmRestApi.errorResponse("Invalid argument: " + quantity);
            }
        }
    }

    @Path(value="/resize/{quantity}")
    @PermitAll
    public static class ResizeResource {
        @PathParam(value="quantity")
        String quantity;
        @DefaultValue(value="")
        @QueryParam(value="key")
        String key;

        @POST
        @Produces(value={"application/json"})
        public Map<String, String> postResize() {
            ResizeRequest request = new ResizeRequest(this.key, this.quantity);
            if (request.error != null) {
                return request.error;
            }
            int curSize = PageTree.dispatcher.getController().getTargetCount();
            PageTree.dispatcher.getController().resizeTo(request.n);
            return AmRestApi.successResponse("Resizing from " + curSize + " to " + request.n);
        }
    }

    @Path(value="/stop")
    @PermitAll
    public static class StopResource {
        @DefaultValue(value="")
        @QueryParam(value="key")
        String key;

        @POST
        @Produces(value={"application/json"})
        public Map<String, String> postStop() {
            Map error = AmRestApi.checkKey(this.key);
            if (error != null) {
                return error;
            }
            PageTree.dispatcher.getController().shutDown();
            return AmRestApi.successResponse("Shutting down");
        }
    }

    @Path(value="/status")
    @PermitAll
    public static class StatusResource {
        @GET
        @Produces(value={"application/json"})
        public Map<String, Object> getStatus() {
            ControllerModel model = new ControllerModel();
            PageTree.dispatcher.getController().visit(model);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("state", model.state.toString());
            HashMap<String, Integer> summary = new HashMap<String, Integer>();
            summary.put("drillMemoryMb", model.totalDrillMemory);
            summary.put("drillVcores", model.totalDrillVcores);
            summary.put("yarnMemoryMb", model.yarnMemory);
            summary.put("yarnVcores", model.yarnVcores);
            summary.put("liveBitCount", model.liveCount);
            summary.put("totalBitCount", model.taskCount);
            summary.put("targetBitCount", model.targetCount);
            summary.put("unmanagedCount", model.getUnmanagedCount());
            summary.put("blackListCount", model.getBlacklistCount());
            summary.put("freeNodeCount", model.getFreeNodeCount());
            root.put("summary", summary);
            ArrayList pools = new ArrayList();
            for (ControllerModel.ClusterGroupModel pool : model.groups) {
                HashMap<String, Object> poolObj = new HashMap<String, Object>();
                poolObj.put("name", pool.name);
                poolObj.put("type", pool.type);
                poolObj.put("liveBitCount", pool.liveCount);
                poolObj.put("targetBitCount", pool.targetCount);
                poolObj.put("totalBitCount", pool.taskCount);
                poolObj.put("totalMemoryMb", pool.memory);
                poolObj.put("totalVcores", pool.vcores);
                pools.add(poolObj);
            }
            root.put("pools", pools);
            AbstractTasksModel.TasksModel tasksModel = new AbstractTasksModel.TasksModel();
            PageTree.dispatcher.getController().visitTasks(tasksModel);
            ArrayList bits = new ArrayList();
            for (AbstractTasksModel.TaskModel task : tasksModel.results) {
                HashMap<String, Object> bitObj = new HashMap<String, Object>();
                bitObj.put("containerId", task.container.getId().toString());
                bitObj.put("host", task.getHost());
                bitObj.put("id", task.id);
                bitObj.put("live", task.isLive());
                bitObj.put("memoryMb", task.memoryMb);
                bitObj.put("vcores", task.vcores);
                bitObj.put("pool", task.groupName);
                bitObj.put("state", task.state);
                bitObj.put("trackingState", task.trackingState);
                bitObj.put("endpoint", ZKClusterCoordinatorDriver.asString(task.endpoint));
                bitObj.put("link", task.getLink());
                bitObj.put("startTime", task.getStartTime());
                bits.add(bitObj);
            }
            root.put("drillbits", bits);
            return root;
        }
    }

    @Path(value="/config")
    @PermitAll
    public static class ConfigResource {
        @GET
        @Produces(value={"application/json"})
        public Map<String, Object> getConfig() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (NameValuePair pair : DrillOnYarnConfig.instance().getPairs()) {
                map.put(pair.getName(), pair.getValue());
            }
            return map;
        }
    }
}

