/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.yarn.appMaster.ClusterController;
import org.apache.drill.yarn.appMaster.ClusterControllerImpl;
import org.apache.drill.yarn.appMaster.ControllerVisitor;
import org.apache.drill.yarn.appMaster.Task;
import org.apache.drill.yarn.appMaster.TaskState;
import org.apache.drill.yarn.appMaster.TaskVisitor;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.zk.ZKRegistry;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Resource;

public abstract class AbstractTasksModel {
    protected boolean supportsDisks;
    protected List<TaskModel> results = new ArrayList<TaskModel>();

    public List<TaskModel> getTasks() {
        return this.results;
    }

    public boolean hasTasks() {
        return !this.results.isEmpty();
    }

    public boolean supportsDiskResource() {
        return this.supportsDisks;
    }

    public static class HistoryModel
    extends AbstractTasksModel
    implements ControllerVisitor {
        @Override
        public void visit(ClusterController controller) {
            ClusterControllerImpl impl = (ClusterControllerImpl)controller;
            for (Task task : impl.getHistory()) {
                this.results.add(new TaskModel(task, false));
            }
        }
    }

    public static class TasksModel
    extends AbstractTasksModel
    implements TaskVisitor {
        protected List<UnmanagedDrillbitModel> unmanaged;
        protected List<String> blacklist;

        @Override
        public void visit(Task task) {
            this.results.add(new TaskModel(task, true));
        }

        public void sortTasks() {
            Collections.sort(this.results, new Comparator<TaskModel>(){

                @Override
                public int compare(TaskModel t1, TaskModel t2) {
                    return Integer.compare(t1.id, t2.id);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listAnomalies(ClusterController controller) {
            this.listUnmanaged(controller);
            ClusterController clusterController = controller;
            synchronized (clusterController) {
                this.blacklist = ((ClusterControllerImpl)controller).getNodeInventory().getBlacklist();
            }
            Collections.sort(this.blacklist);
        }

        private void listUnmanaged(ClusterController controller) {
            ZKRegistry zkRegistry = (ZKRegistry)controller.getProperty("zk");
            if (zkRegistry == null) {
                return;
            }
            List<String> endpoints = zkRegistry.listUnmanagedDrillits();
            if (endpoints.isEmpty()) {
                return;
            }
            this.unmanaged = new ArrayList<UnmanagedDrillbitModel>();
            for (String endpoint : endpoints) {
                this.unmanaged.add(new UnmanagedDrillbitModel(endpoint));
            }
        }

        public List<UnmanagedDrillbitModel> getUnnamaged() {
            return this.unmanaged;
        }

        public boolean hasUnmanagedDrillbits() {
            return this.unmanaged != null;
        }

        public int getUnmanagedDrillbitCount() {
            return this.unmanaged == null ? 0 : this.unmanaged.size();
        }

        public boolean hasBlacklist() {
            return !this.blacklist.isEmpty();
        }

        public int getBlacklistCount() {
            return this.blacklist.size();
        }

        public List<String> getBlacklist() {
            return this.blacklist;
        }
    }

    public static class UnmanagedDrillbitModel {
        protected String host;
        protected String ports;

        public UnmanagedDrillbitModel(String endpoint) {
            String[] parts = endpoint.split(":");
            if (parts.length < 4) {
                this.host = endpoint;
                this.ports = "";
            } else {
                this.host = parts[0];
                ArrayList<String> thePorts = new ArrayList<String>();
                thePorts.add(parts[1]);
                thePorts.add(parts[2]);
                thePorts.add(parts[3]);
                this.ports = DoYUtil.join(", ", thePorts);
            }
        }

        public String getHost() {
            return this.host;
        }

        public String getPorts() {
            return this.ports;
        }
    }

    public static class TaskModel {
        public int id;
        protected String groupName;
        protected boolean isLive;
        protected TaskState taskState;
        protected String taskStateHint;
        protected String state;
        protected boolean cancelled;
        protected String trackingState;
        protected String trackingStateHint;
        protected Container container;
        protected CoordinationProtos.DrillbitEndpoint endpoint;
        protected long startTime;
        protected int memoryMb;
        protected int vcores;
        protected double disks;
        protected String containerId;
        protected String nmLink;
        protected long endTime;
        protected String disposition;
        protected int tryCount;
        private Map<TaskState, String> stateHints = this.makeStateHints();
        private Map<Task.TrackingState, String> trackingStateHints = this.makeTrackingStateHints();

        public TaskModel(Task task, boolean live) {
            this.id = task.taskId;
            this.groupName = task.scheduler.getName();
            this.taskState = task.getState();
            this.taskStateHint = this.stateHints.get(this.taskState);
            this.state = this.taskState.getLabel();
            this.cancelled = task.isCancelled();
            this.isLive = live && this.taskState == TaskState.RUNNING;
            Task.TrackingState tState = task.getTrackingState();
            this.trackingState = tState.getDisplayName();
            this.trackingStateHint = this.trackingStateHints.get((Object)tState);
            this.container = task.container;
            this.startTime = task.launchTime;
            if (task.container != null) {
                this.containerId = task.container.getId().toString();
                Resource resource = task.container.getResource();
                this.memoryMb = resource.getMemory();
                this.vcores = resource.getVirtualCores();
                this.disks = task.getContainerSpec().disks;
                this.nmLink = "http://" + task.container.getNodeHttpAddress();
            } else {
                this.memoryMb = task.scheduler.getResource().memoryMb;
                this.vcores = task.scheduler.getResource().vCores;
            }
            this.endpoint = (CoordinationProtos.DrillbitEndpoint)task.properties.get("endpoint");
            if (!live) {
                this.endTime = task.completionTime;
                this.tryCount = task.tryCount;
                this.disposition = this.state;
                if (task.disposition != null) {
                    this.disposition = task.disposition.toString();
                }
                if (task.completionStatus != null) {
                    this.disposition = TaskModel.reformatDiagnostics(task.completionStatus.getDiagnostics());
                }
                if (task.error != null) {
                    this.disposition = task.error.getMessage();
                }
            }
        }

        public static String reformatDiagnostics(String orig) {
            try {
                String line;
                StringBuilder buf = new StringBuilder();
                BufferedReader reader = new BufferedReader(new StringReader(orig));
                FormatState state = FormatState.PRE_STACK;
                block6: while ((line = reader.readLine()) != null) {
                    switch (state) {
                        case PRE_STACK: {
                            if (line.startsWith("Container id:")) continue block6;
                            if (!line.startsWith("Stack trace:")) break;
                            state = FormatState.IN_STACK;
                            continue block6;
                        }
                        case IN_STACK: {
                            if (!line.trim().isEmpty()) continue block6;
                            state = FormatState.POST_STACK;
                            continue block6;
                        }
                    }
                    if (line.trim().isEmpty()) continue;
                    buf.append(line);
                    buf.append("<br/>\n");
                }
                buf.append("See log file for details.");
                return buf.toString();
            }
            catch (IOException e) {
                return orig.replace("\n", "<br>\n");
            }
        }

        private Map<TaskState, String> makeStateHints() {
            HashMap<TaskState, String> hints = new HashMap<TaskState, String>();
            hints.put(TaskState.START, "Queued to send a container request to YARN.");
            hints.put(TaskState.REQUESTING, "Container request sent to YARN.");
            hints.put(TaskState.LAUNCHING, "YARN provided a container, send launch request.");
            hints.put(TaskState.WAIT_START_ACK, "Drillbit launched, waiting for ZooKeeper registration.");
            hints.put(TaskState.RUNNING, "Drillbit is running normally.");
            hints.put(TaskState.ENDING, "Graceful shutdown request sent to the Drillbit.");
            hints.put(TaskState.KILLING, "Sent the YARN Node Manager a request to forcefully kill the Drillbit.");
            hints.put(TaskState.WAIT_END_ACK, "Drillbit has shut down; waiting for ZooKeeper to confirm.");
            hints.put(TaskState.END, "The Drillbit has shut down.");
            return hints;
        }

        private Map<Task.TrackingState, String> makeTrackingStateHints() {
            HashMap<Task.TrackingState, String> hints = new HashMap<Task.TrackingState, String>();
            hints.put(Task.TrackingState.UNTRACKED, "Task is not tracked in ZooKeeper.");
            hints.put(Task.TrackingState.NEW, "Drillbit has not yet registered with ZooKeeper.");
            hints.put(Task.TrackingState.START_ACK, "Drillbit has registered normally with ZooKeeper.");
            hints.put(Task.TrackingState.END_ACK, "Drillbit is no longer registered with ZooKeeper.");
            return hints;
        }

        public String getTaskId() {
            return Integer.toString(this.id);
        }

        public String getGroupName() {
            return this.groupName;
        }

        public boolean isLive() {
            return this.isLive;
        }

        public String getHost() {
            if (this.container == null) {
                return "";
            }
            return this.container.getNodeId().getHost();
        }

        public String getLink() {
            if (this.endpoint == null) {
                return "";
            }
            String port = DrillOnYarnConfig.config().getString("drill.exec.http.port");
            String protocol = "http:";
            if (DrillOnYarnConfig.config().getBoolean("drill.exec.http.ssl_enabled")) {
                protocol = "https:";
            }
            return protocol + "//" + this.endpoint.getAddress() + ":" + port + "/";
        }

        public String getState() {
            return this.state.toString();
        }

        public String getStateHint() {
            return this.taskStateHint;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean isCancellable() {
            return !this.cancelled && this.taskState.isCancellable();
        }

        public String getTrackingState() {
            return this.trackingState;
        }

        public String getTrackingStateHint() {
            return this.trackingStateHint;
        }

        public String getStartTime() {
            if (this.startTime == 0L) {
                return "";
            }
            return DoYUtil.toIsoTime(this.startTime);
        }

        public int getMemory() {
            return this.memoryMb;
        }

        public int getVcores() {
            return this.vcores;
        }

        public String getDisks() {
            return String.format("%.2f", this.disks);
        }

        public boolean hasContainer() {
            return this.containerId != null;
        }

        public String getContainerId() {
            return this.displayString(this.containerId);
        }

        public String getNmLink() {
            return this.displayString(this.nmLink);
        }

        public String getDisposition() {
            return this.displayString(this.disposition);
        }

        public int getTryCount() {
            return this.tryCount;
        }

        public String displayString(String value) {
            return value == null ? "" : value;
        }

        public String getEndTime() {
            if (this.endTime == 0L) {
                return "";
            }
            return DoYUtil.toIsoTime(this.endTime);
        }

        private static enum FormatState {
            PRE_STACK,
            IN_STACK,
            POST_STACK;

        }
    }
}

