/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.ShouldNeverHappenException;

public class CompatibilityUtil {
    private static boolean useV21;
    public static final V21FileAPI fileAPI;

    private static Object invoke(Method method, String errorMsg, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(errorMsg, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(errorMsg, e);
        }
    }

    public static int getBuf(FSDataInputStream f, ByteBuffer readBuf, int maxSize) throws IOException {
        int res;
        if (useV21) {
            try {
                res = (Integer)fileAPI.PROVIDE_BUF_READ_METHOD.invoke((Object)f, readBuf);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof UnsupportedOperationException) {
                    useV21 = false;
                    return CompatibilityUtil.getBuf(f, readBuf, maxSize);
                }
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException("Error reading out of an FSDataInputStream using the Hadoop 2 ByteBuffer based read method.", e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new ShouldNeverHappenException((Throwable)e);
            }
        } else {
            byte[] buf = new byte[maxSize];
            res = f.read(buf);
            readBuf.put(buf, 0, res);
        }
        return res;
    }

    static {
        boolean v21 = true;
        try {
            Class.forName("org.apache.hadoop.io.compress.DirectDecompressor");
        }
        catch (ClassNotFoundException cnfe) {
            v21 = false;
        }
        useV21 = v21;
        try {
            fileAPI = v21 ? new V21FileAPI() : null;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Error finding appropriate interfaces using reflection.", e);
        }
    }

    private static class V21FileAPI {
        private final Method PROVIDE_BUF_READ_METHOD;
        private final Class<?> FSDataInputStreamCls;

        private V21FileAPI() throws ReflectiveOperationException {
            String PACKAGE = "org.apache.hadoop";
            this.FSDataInputStreamCls = Class.forName("org.apache.hadoop.fs.FSDataInputStream");
            this.PROVIDE_BUF_READ_METHOD = this.FSDataInputStreamCls.getMethod("read", ByteBuffer.class);
        }
    }
}

