/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sqlline.ColorBuffer;
import sqlline.OutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;

class TableOutputFormat
implements OutputFormat {
    private final SqlLine sqlLine;
    private final int resizeFrequency;

    public TableOutputFormat(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
        this.resizeFrequency = sqlLine.getOpts().getHeaderInterval() == 0 ? 50 : sqlLine.getOpts().getHeaderInterval();
    }

    public int print(Rows rows) {
        int index = 0;
        ColorBuffer header = null;
        Rows.Row headerRow = null;
        ColorBuffer headerCols = null;
        int width = this.sqlLine.getOpts().getMaxWidth() - 4;
        ResizingRowsProvider provider = new ResizingRowsProvider(rows);
        while (provider.hasNext()) {
            Rows.Row row = provider.next();
            if (index == 0) {
                headerRow = row;
            }
            ColorBuffer cbuf = this.getOutputString(rows, row);
            cbuf = cbuf.truncate(width);
            if (index == 0 || this.sqlLine.getOpts().getHeaderInterval() > 0 && index % this.sqlLine.getOpts().getHeaderInterval() == 0 && this.sqlLine.getOpts().getShowHeader()) {
                headerCols = this.getOutputString(rows, headerRow);
                headerCols = headerCols.truncate(width);
                StringBuilder h = new StringBuilder();
                for (int j = 0; j < row.sizes.length; ++j) {
                    for (int k = 0; k < row.sizes[j]; ++k) {
                        h.append('-');
                    }
                    h.append("-+-");
                }
                header = this.sqlLine.getColorBuffer().cyan(h.toString()).truncate(headerCols.getVisibleLength());
                this.printRow(header, true);
                this.printRow(headerCols, false);
                this.printRow(header, true);
            }
            if (index != 0) {
                this.printRow(cbuf, false);
            }
            ++index;
        }
        if (header != null && this.sqlLine.getOpts().getShowHeader()) {
            this.printRow(header, true);
        }
        return index - 1;
    }

    void printRow(ColorBuffer cbuff, boolean header) {
        if (header) {
            this.sqlLine.output(this.sqlLine.getColorBuffer().cyan("+-").append(cbuff).cyan("-+"));
        } else {
            this.sqlLine.output(this.sqlLine.getColorBuffer().cyan("| ").append(cbuff).cyan(" |"));
        }
    }

    public ColorBuffer getOutputString(Rows rows, Rows.Row row) {
        return this.getOutputString(rows, row, " | ");
    }

    ColorBuffer getOutputString(Rows rows, Rows.Row row, String delim) {
        ColorBuffer buf = this.sqlLine.getColorBuffer();
        for (int i = 0; i < row.values.length; ++i) {
            ColorBuffer v;
            if (buf.getVisibleLength() > 0) {
                buf.cyan(delim);
            }
            if (row.isMeta) {
                v = this.sqlLine.getColorBuffer().center(row.values[i], row.sizes[i]);
                if (rows.isPrimaryKey(i)) {
                    buf.cyan(v.getMono());
                    continue;
                }
                buf.bold(v.getMono());
                continue;
            }
            v = this.sqlLine.getColorBuffer().pad(row.values[i], row.sizes[i]);
            if (rows.isPrimaryKey(i)) {
                buf.cyan(v.getMono());
                continue;
            }
            buf.append(v.getMono());
        }
        if (row.deleted) {
            buf = this.sqlLine.getColorBuffer().red(buf.getMono());
        } else if (row.updated) {
            buf = this.sqlLine.getColorBuffer().blue(buf.getMono());
        } else if (row.inserted) {
            buf = this.sqlLine.getColorBuffer().green(buf.getMono());
        }
        return buf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResizingRowsProvider
    implements Iterator<Rows.Row> {
        private final List<Rows.Row> buffer;
        private Rows.Row header;
        private boolean firstRowFound;
        private int[] headerColSizes;
        private int current;
        private final Rows rows;

        public ResizingRowsProvider(Rows rows) {
            this.buffer = new ArrayList<Rows.Row>(TableOutputFormat.this.resizeFrequency);
            this.firstRowFound = false;
            this.current = -1;
            this.rows = rows;
        }

        @Override
        public boolean hasNext() {
            return this.current + 1 < this.buffer.size() || this.rows.hasNext();
        }

        void normalizeWidths(List<Rows.Row> list) {
            if (!this.firstRowFound) {
                this.header = list.get(0);
                this.firstRowFound = true;
                this.headerColSizes = this.header.sizes;
            }
            int[] max = (int[])this.headerColSizes.clone();
            for (Rows.Row row : list) {
                for (int j = 0; j < max.length; ++j) {
                    max[j] = Math.max(max[j], row.sizes[j] + 1);
                    if (max[j] <= 120) continue;
                    this.header.sizes = this.headerColSizes;
                    return;
                }
            }
            for (Rows.Row row : list) {
                row.sizes = max;
            }
            this.header.sizes = max;
        }

        @Override
        public Rows.Row next() {
            ++this.current;
            if (this.current < this.buffer.size()) {
                return this.buffer.get(this.current);
            }
            this.buffer.clear();
            for (int i = 0; i < TableOutputFormat.this.resizeFrequency && this.rows.hasNext(); ++i) {
                this.buffer.add((Rows.Row)this.rows.next());
            }
            this.normalizeWidths(this.buffer);
            this.current = 0;
            if (this.buffer.isEmpty()) {
                return null;
            }
            return this.buffer.get(0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

