/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import org.apache.drill.exec.rpc.EncryptionContext;

public class EncryptionContextImpl
implements EncryptionContext {
    private boolean encryptionEnabled;
    private int maxWrappedSize;
    private int wrapSizeLimit;

    EncryptionContextImpl() {
        this.encryptionEnabled = false;
        this.maxWrappedSize = 65536;
        this.wrapSizeLimit = 0;
    }

    EncryptionContextImpl(EncryptionContext context) {
        this.encryptionEnabled = context.isEncryptionEnabled();
        this.maxWrappedSize = context.getMaxWrappedSize();
        this.wrapSizeLimit = context.getWrapSizeLimit();
    }

    @Override
    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    @Override
    public void setEncryption(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
    }

    @Override
    public int getMaxWrappedSize() {
        return this.maxWrappedSize;
    }

    @Override
    public void setMaxWrappedSize(int maxWrappedSize) {
        this.maxWrappedSize = maxWrappedSize;
    }

    @Override
    public String getEncryptionCtxtString() {
        return this.toString();
    }

    @Override
    public void setWrapSizeLimit(int wrapSizeLimit) {
        this.wrapSizeLimit = wrapSizeLimit;
    }

    @Override
    public int getWrapSizeLimit() {
        return this.wrapSizeLimit;
    }

    private String getEncryptionString() {
        return this.encryptionEnabled ? "enabled" : "disabled";
    }

    public String toString() {
        return ("Encryption: " + this.getEncryptionString() + " , MaxWrappedSize: " + this.maxWrappedSize + " , WrapSizeLimit: " + this.wrapSizeLimit).intern();
    }
}

