/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.kafka.KafkaScanSpec;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessageSchema
extends AbstractSchema {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageSchema.class);
    private final KafkaStoragePlugin plugin;
    private final Map<String, DrillTable> drillTables = Maps.newHashMap();
    private Set<String> tableNames;

    public KafkaMessageSchema(KafkaStoragePlugin plugin, String name) {
        super((List)ImmutableList.of(), name);
        this.plugin = plugin;
    }

    public String getTypeName() {
        return "kafka";
    }

    void setHolder(SchemaPlus plusOfThis) {
        for (String s : this.getSubSchemaNames()) {
            plusOfThis.add(s, this.getSubSchema(s));
        }
    }

    public Table getTable(String tableName) {
        if (!this.drillTables.containsKey(tableName)) {
            KafkaScanSpec scanSpec = new KafkaScanSpec(tableName);
            DynamicDrillTable table = new DynamicDrillTable((StoragePlugin)this.plugin, this.getName(), (Object)scanSpec);
            this.drillTables.put(tableName, (DrillTable)table);
        }
        return (Table)this.drillTables.get(tableName);
    }

    public Set<String> getTableNames() {
        if (this.tableNames == null) {
            try (KafkaConsumer kafkaConsumer = new KafkaConsumer(this.plugin.getConfig().getKafkaConsumerProps());){
                this.tableNames = kafkaConsumer.listTopics().keySet();
            }
            catch (KafkaException e) {
                throw UserException.dataReadError((Throwable)e).message("Failed to get tables information", new Object[0]).addContext(e.getMessage()).build(logger);
            }
        }
        return this.tableNames;
    }
}

