/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.KafkaStoragePluginConfig;

@JsonTypeName(value="kafka-partition-scan")
public class KafkaSubScan
extends AbstractBase
implements SubScan {
    @JsonProperty
    private final KafkaStoragePluginConfig KafkaStoragePluginConfig;
    @JsonIgnore
    private final KafkaStoragePlugin kafkaStoragePlugin;
    private final List<SchemaPath> columns;
    private final List<KafkaSubScanSpec> partitions;

    @JsonCreator
    public KafkaSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="kafkaStoragePluginConfig") KafkaStoragePluginConfig kafkaStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="partitionSubScanSpecList") LinkedList<KafkaSubScanSpec> partitions) throws ExecutionSetupException {
        super(userName);
        this.KafkaStoragePluginConfig = kafkaStoragePluginConfig;
        this.columns = columns;
        this.partitions = partitions;
        this.kafkaStoragePlugin = (KafkaStoragePlugin)registry.getPlugin((StoragePluginConfig)kafkaStoragePluginConfig);
    }

    public KafkaSubScan(String userName, KafkaStoragePlugin plugin, KafkaStoragePluginConfig kafkStoragePluginConfig, List<SchemaPath> columns, List<KafkaSubScanSpec> partitionSubScanSpecList) {
        super(userName);
        this.columns = columns;
        this.KafkaStoragePluginConfig = kafkStoragePluginConfig;
        this.kafkaStoragePlugin = plugin;
        this.partitions = partitionSubScanSpecList;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new KafkaSubScan(this.getUserName(), this.kafkaStoragePlugin, this.KafkaStoragePluginConfig, this.columns, this.partitions);
    }

    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    @JsonIgnore
    public KafkaStoragePluginConfig getKafkaStoragePluginConfig() {
        return this.KafkaStoragePluginConfig;
    }

    @JsonIgnore
    public KafkaStoragePlugin getKafkaStoragePlugin() {
        return this.kafkaStoragePlugin;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public List<KafkaSubScanSpec> getPartitionSubScanSpecList() {
        return this.partitions;
    }

    public int getOperatorType() {
        return 40;
    }

    public static class KafkaSubScanSpec {
        protected String topicName;
        protected int partitionId;
        protected long startOffset;
        protected long endOffset;

        @JsonCreator
        public KafkaSubScanSpec(@JsonProperty(value="topicName") String topicName, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="startOffset") long startOffset, @JsonProperty(value="endOffset") long endOffset) {
            this.topicName = topicName;
            this.partitionId = partitionId;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        KafkaSubScanSpec() {
        }

        public String getTopicName() {
            return this.topicName;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public long getEndOffset() {
            return this.endOffset;
        }

        public KafkaSubScanSpec setTopicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public KafkaSubScanSpec setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public KafkaSubScanSpec setStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public KafkaSubScanSpec setEndOffset(long endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public String toString() {
            return "KafkaSubScanSpec [topicName=" + this.topicName + ", partitionId=" + this.partitionId + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + "]";
        }
    }
}

