/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Properties;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="kafka")
public class KafkaStoragePluginConfig
extends StoragePluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(KafkaStoragePluginConfig.class);
    public static final String NAME = "kafka";
    private Properties kafkaConsumerProps = new Properties();

    @JsonCreator
    public KafkaStoragePluginConfig(@JsonProperty(value="kafkaConsumerProps") Map<String, String> kafkaConsumerProps) {
        this.kafkaConsumerProps.putAll(kafkaConsumerProps);
        logger.debug("Kafka Consumer Props {}", (Object)this.kafkaConsumerProps);
    }

    public Properties getKafkaConsumerProps() {
        return this.kafkaConsumerProps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kafkaConsumerProps == null ? 0 : this.kafkaConsumerProps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        KafkaStoragePluginConfig other = (KafkaStoragePluginConfig)((Object)obj);
        if (this.kafkaConsumerProps == null && other.kafkaConsumerProps == null) {
            return true;
        }
        if (this.kafkaConsumerProps == null || other.kafkaConsumerProps == null) {
            return false;
        }
        return this.kafkaConsumerProps.equals(other.kafkaConsumerProps);
    }
}

