/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.kafka.KafkaGroupScan;
import org.apache.drill.exec.store.kafka.KafkaScanSpec;
import org.apache.drill.exec.store.kafka.KafkaStoragePluginConfig;
import org.apache.drill.exec.store.kafka.schema.KafkaSchemaFactory;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(KafkaStoragePlugin.class);
    private final KafkaSchemaFactory kafkaSchemaFactory;
    private final KafkaStoragePluginConfig config;
    private final DrillbitContext context;
    private final Closer closer = Closer.create();

    public KafkaStoragePlugin(KafkaStoragePluginConfig config, DrillbitContext context, String name) throws ExecutionSetupException {
        super(context, name);
        logger.debug("Initializing {}", (Object)KafkaStoragePlugin.class.getName());
        this.config = config;
        this.context = context;
        this.kafkaSchemaFactory = new KafkaSchemaFactory(this, name);
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public KafkaStoragePluginConfig getConfig() {
        return this.config;
    }

    public boolean supportsRead() {
        return true;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        this.kafkaSchemaFactory.registerSchemas(schemaConfig, parent);
    }

    public Set<StoragePluginOptimizerRule> getPhysicalOptimizerRules(OptimizerRulesContext optimizerRulesContext) {
        return ImmutableSet.of();
    }

    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection) throws IOException {
        KafkaScanSpec kafkaScanSpec = (KafkaScanSpec)selection.getListWith(new ObjectMapper(), (TypeReference)new TypeReference<KafkaScanSpec>(){});
        return new KafkaGroupScan(this, kafkaScanSpec, null);
    }

    public KafkaConsumer<byte[], byte[]> registerConsumer(KafkaConsumer<byte[], byte[]> consumer) {
        return (KafkaConsumer)this.closer.register(consumer);
    }

    public void close() throws IOException {
        this.closer.close();
    }
}

