/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.kafka.KafkaRecordReader;
import org.apache.drill.exec.store.kafka.KafkaSubScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaScanBatchCreator
implements BatchCreator<KafkaSubScan> {
    static final Logger logger = LoggerFactory.getLogger(KafkaScanBatchCreator.class);

    public CloseableRecordBatch getBatch(FragmentContext context, KafkaSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        List<SchemaPath> columns = subScan.getColumns() != null ? subScan.getColumns() : GroupScan.ALL_COLUMNS;
        ArrayList readers = Lists.newArrayListWithCapacity((int)subScan.getPartitionSubScanSpecList().size());
        for (KafkaSubScan.KafkaSubScanSpec scanSpec : subScan.getPartitionSubScanSpecList()) {
            readers.add(new KafkaRecordReader(scanSpec, columns, context, subScan.getKafkaStoragePlugin()));
        }
        logger.info("Number of record readers initialized : {}", (Object)readers.size());
        return new ScanBatch((PhysicalOperator)subScan, context, (List)readers);
    }
}

