/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.KafkaSubScan;
import org.apache.drill.exec.store.kafka.MessageIterator;
import org.apache.drill.exec.store.kafka.decoders.MessageReader;
import org.apache.drill.exec.store.kafka.decoders.MessageReaderFactory;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(KafkaRecordReader.class);
    public static final long DEFAULT_MESSAGES_PER_BATCH = 4000L;
    private VectorContainerWriter writer;
    private MessageReader messageReader;
    private final boolean unionEnabled;
    private final KafkaStoragePlugin plugin;
    private final KafkaSubScan.KafkaSubScanSpec subScanSpec;
    private final long kafkaPollTimeOut;
    private long currentOffset;
    private MessageIterator msgItr;
    private final boolean enableAllTextMode;
    private final boolean readNumbersAsDouble;
    private final String kafkaMsgReader;

    public KafkaRecordReader(KafkaSubScan.KafkaSubScanSpec subScanSpec, List<SchemaPath> projectedColumns, FragmentContext context, KafkaStoragePlugin plugin) {
        this.setColumns(projectedColumns);
        this.enableAllTextMode = context.getOptions().getOption((String)"store.kafka.all_text_mode").bool_val;
        this.readNumbersAsDouble = context.getOptions().getOption((String)"store.kafka.read_numbers_as_double").bool_val;
        OptionManager options = context.getOptions();
        this.unionEnabled = options.getOption(ExecConstants.ENABLE_UNION_TYPE);
        this.kafkaMsgReader = options.getOption((String)"store.kafka.record.reader").string_val;
        this.kafkaPollTimeOut = options.getOption((String)"store.kafka.poll.timeout").num_val;
        this.plugin = plugin;
        this.subScanSpec = subScanSpec;
    }

    protected Collection<SchemaPath> transformColumns(Collection<SchemaPath> projectedColumns) {
        LinkedHashSet transformed = Sets.newLinkedHashSet();
        if (!this.isStarQuery()) {
            for (SchemaPath column : projectedColumns) {
                transformed.add(column);
            }
        } else {
            transformed.add(Utilities.STAR_COLUMN);
        }
        return transformed;
    }

    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        this.writer = new VectorContainerWriter(output, this.unionEnabled);
        this.messageReader = MessageReaderFactory.getMessageReader(this.kafkaMsgReader);
        this.messageReader.init(context.getManagedBuffer(), Lists.newArrayList((Iterable)this.getColumns()), this.writer, this.enableAllTextMode, this.readNumbersAsDouble);
        this.msgItr = new MessageIterator(this.messageReader.getConsumer(this.plugin), this.subScanSpec, this.kafkaPollTimeOut);
    }

    public int next() {
        this.writer.allocate();
        this.writer.reset();
        Stopwatch watch = Stopwatch.createStarted();
        int messageCount = 0;
        try {
            while (this.currentOffset < this.subScanSpec.getEndOffset() - 1L && this.msgItr.hasNext()) {
                ConsumerRecord<byte[], byte[]> consumerRecord = this.msgItr.next();
                this.currentOffset = consumerRecord.offset();
                this.writer.setPosition(messageCount);
                this.messageReader.readMessage(consumerRecord);
                if ((long)(++messageCount) < 4000L) continue;
                break;
            }
            this.messageReader.ensureAtLeastOneField();
            this.writer.setValueCount(messageCount);
            logger.debug("Took {} ms to process {} records.", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)messageCount);
            logger.debug("Last offset consumed for {}:{} is {}", new Object[]{this.subScanSpec.getTopicName(), this.subScanSpec.getPartitionId(), this.currentOffset});
            return messageCount;
        }
        catch (Exception e) {
            String msg = "Failure while reading messages from kafka. Recordreader was at record: " + (messageCount + 1);
            throw UserException.dataReadError((Throwable)e).message(msg, new Object[0]).addContext(e.getMessage()).build(logger);
        }
    }

    public void close() throws Exception {
        logger.info("Last offset processed for {}:{} is - {}", new Object[]{this.subScanSpec.getTopicName(), this.subScanSpec.getPartitionId(), this.currentOffset});
        logger.info("Total time to fetch messages from {}:{} is - {} milliseconds", new Object[]{this.subScanSpec.getTopicName(), this.subScanSpec.getPartitionId(), this.msgItr.getTotalFetchTime()});
        this.messageReader.close();
    }
}

