/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.kafka.KafkaScanSpec;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.drill.exec.store.kafka.KafkaStoragePluginConfig;
import org.apache.drill.exec.store.kafka.KafkaSubScan;
import org.apache.drill.exec.store.schedule.AffinityCreator;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="kafka-scan")
public class KafkaGroupScan
extends AbstractGroupScan {
    private static final Logger logger = LoggerFactory.getLogger(KafkaGroupScan.class);
    private static final long MSG_SIZE = 1024L;
    private final KafkaStoragePlugin kafkaStoragePlugin;
    private final KafkaStoragePluginConfig kafkaStoragePluginConfig;
    private List<SchemaPath> columns;
    private final KafkaScanSpec kafkaScanSpec;
    private List<PartitionScanWork> partitionWorkList;
    private ListMultimap<Integer, PartitionScanWork> assignments;
    private List<EndpointAffinity> affinities;

    @JsonCreator
    public KafkaGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="kafkaStoragePluginConfig") KafkaStoragePluginConfig kafkaStoragePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="scanSpec") KafkaScanSpec scanSpec, @JacksonInject StoragePluginRegistry pluginRegistry) {
        this(userName, kafkaStoragePluginConfig, columns, scanSpec, (KafkaStoragePlugin)pluginRegistry);
    }

    public KafkaGroupScan(KafkaStoragePlugin kafkaStoragePlugin, KafkaScanSpec kafkaScanSpec, List<SchemaPath> columns) {
        super("");
        this.kafkaStoragePlugin = kafkaStoragePlugin;
        this.kafkaStoragePluginConfig = kafkaStoragePlugin.getConfig();
        this.columns = columns;
        this.kafkaScanSpec = kafkaScanSpec;
        this.init();
    }

    public KafkaGroupScan(String userName, KafkaStoragePluginConfig kafkaStoragePluginConfig, List<SchemaPath> columns, KafkaScanSpec kafkaScanSpec, KafkaStoragePlugin pluginRegistry) {
        super(userName);
        this.kafkaStoragePluginConfig = kafkaStoragePluginConfig;
        this.columns = columns;
        this.kafkaScanSpec = kafkaScanSpec;
        this.kafkaStoragePlugin = pluginRegistry;
        this.init();
    }

    public KafkaGroupScan(KafkaGroupScan that) {
        super((AbstractGroupScan)that);
        this.kafkaStoragePluginConfig = that.kafkaStoragePluginConfig;
        this.columns = that.columns;
        this.kafkaScanSpec = that.kafkaScanSpec;
        this.kafkaStoragePlugin = that.kafkaStoragePlugin;
        this.partitionWorkList = that.partitionWorkList;
        this.assignments = that.assignments;
    }

    private void init() {
        this.partitionWorkList = Lists.newArrayList();
        Collection endpoints = this.kafkaStoragePlugin.getContext().getBits();
        HashMap endpointMap = Maps.newHashMap();
        for (CoordinationProtos.DrillbitEndpoint endpoint : endpoints) {
            endpointMap.put(endpoint.getAddress(), endpoint);
        }
        HashMap startOffsetsMap = Maps.newHashMap();
        HashMap endOffsetsMap = Maps.newHashMap();
        List topicPartitions = null;
        String topicName = this.kafkaScanSpec.getTopicName();
        try (KafkaConsumer kafkaConsumer = new KafkaConsumer(this.kafkaStoragePlugin.getConfig().getKafkaConsumerProps(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            if (!kafkaConsumer.listTopics().keySet().contains(topicName)) {
                throw UserException.dataReadError().message("Table '%s' does not exist", new Object[]{topicName}).build(logger);
            }
            kafkaConsumer.subscribe(Arrays.asList(topicName));
            kafkaConsumer.poll(0L);
            Set assignments = kafkaConsumer.assignment();
            topicPartitions = kafkaConsumer.partitionsFor(topicName);
            kafkaConsumer.seekToBeginning((Collection)assignments);
            for (TopicPartition topicPartition : assignments) {
                startOffsetsMap.put(topicPartition, kafkaConsumer.position(topicPartition));
            }
            kafkaConsumer.seekToEnd((Collection)assignments);
            for (TopicPartition topicPartition : assignments) {
                endOffsetsMap.put(topicPartition, kafkaConsumer.position(topicPartition));
            }
        }
        catch (Exception e) {
            throw UserException.dataReadError((Throwable)e).message("Failed to fetch start/end offsets of the topic  %s", new Object[]{topicName}).addContext(e.getMessage()).build(logger);
        }
        for (PartitionInfo partitionInfo : topicPartitions) {
            Node[] inSyncReplicas;
            TopicPartition topicPartition = new TopicPartition(topicName, partitionInfo.partition());
            long lastCommittedOffset = (Long)startOffsetsMap.get(topicPartition);
            long latestOffset = (Long)endOffsetsMap.get(topicPartition);
            logger.debug("Latest offset of {} is {}", (Object)topicPartition, (Object)latestOffset);
            logger.debug("Last committed offset of {} is {}", (Object)topicPartition, (Object)lastCommittedOffset);
            PartitionScanWork work = new PartitionScanWork(topicPartition, lastCommittedOffset, latestOffset);
            for (Node isr : inSyncReplicas = partitionInfo.inSyncReplicas()) {
                String host = isr.host();
                CoordinationProtos.DrillbitEndpoint ep = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(host);
                if (ep == null) continue;
                work.getByteMap().add(ep, work.getTotalBytes());
            }
            this.partitionWorkList.add(work);
        }
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> incomingEndpoints) {
        this.assignments = AssignmentCreator.getMappings(incomingEndpoints, this.partitionWorkList);
    }

    public KafkaSubScan getSpecificScan(int minorFragmentId) {
        List workList = this.assignments.get((Object)minorFragmentId);
        ArrayList scanSpecList = Lists.newArrayList();
        for (PartitionScanWork work : workList) {
            scanSpecList.add(new KafkaSubScan.KafkaSubScanSpec(work.getTopicPartition().topic(), work.getTopicPartition().partition(), work.getBeginOffset(), work.getLatestOffset()));
        }
        return new KafkaSubScan(this.getUserName(), this.kafkaStoragePlugin, this.kafkaStoragePluginConfig, this.columns, scanSpecList);
    }

    public int getMaxParallelizationWidth() {
        return this.partitionWorkList.size();
    }

    public ScanStats getScanStats() {
        long messageCount = 0L;
        for (PartitionScanWork work : this.partitionWorkList) {
            messageCount += work.getLatestOffset() - work.getBeginOffset();
        }
        return new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, (double)messageCount, 1.0, (double)(messageCount * 1024L));
    }

    public String getDigest() {
        return this.toString();
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new KafkaGroupScan(this);
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.affinities == null) {
            this.affinities = AffinityCreator.getAffinityMap(this.partitionWorkList);
        }
        return this.affinities;
    }

    @JsonIgnore
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        KafkaGroupScan clone = new KafkaGroupScan(this);
        clone.columns = columns;
        return clone;
    }

    @JsonProperty(value="kafkaStoragePluginConfig")
    public KafkaStoragePluginConfig getStorageConfig() {
        return this.kafkaStoragePluginConfig;
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="kafkaScanSpec")
    public KafkaScanSpec getScanSpec() {
        return this.kafkaScanSpec;
    }

    @JsonIgnore
    public KafkaStoragePlugin getStoragePlugin() {
        return this.kafkaStoragePlugin;
    }

    public String toString() {
        return String.format("KafkaGroupScan [KafkaScanSpec=%s, columns=%s]", this.kafkaScanSpec, this.columns);
    }

    private static class PartitionScanWork
    implements CompleteWork {
        private final EndpointByteMapImpl byteMap = new EndpointByteMapImpl();
        private final TopicPartition topicPartition;
        private final long beginOffset;
        private final long latestOffset;

        public PartitionScanWork(TopicPartition topicPartition, long beginOffset, long latestOffset) {
            this.topicPartition = topicPartition;
            this.beginOffset = beginOffset;
            this.latestOffset = latestOffset;
        }

        public TopicPartition getTopicPartition() {
            return this.topicPartition;
        }

        public long getBeginOffset() {
            return this.beginOffset;
        }

        public long getLatestOffset() {
            return this.latestOffset;
        }

        public int compareTo(CompleteWork o) {
            return Long.compare(this.getTotalBytes(), o.getTotalBytes());
        }

        public long getTotalBytes() {
            return (this.latestOffset - this.beginOffset) * 1024L;
        }

        public EndpointByteMap getByteMap() {
            return this.byteMap;
        }
    }
}

