/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.utils.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.mapr.fs.utils.ssh.SSHUserInfo;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHSession {
    private static final Logger logger = LoggerFactory.getLogger(SSHSession.class);
    private static final String userHome = System.getProperty("user.home");
    private static final File sshDir = new File(userHome, ".ssh");
    private static JSch jsch = null;
    private static final AtomicInteger idTracker = new AtomicInteger();
    private final Session session;
    private final String id = String.valueOf(idTracker.incrementAndGet());

    public SSHSession(String user, String host) throws JSchException {
        this.session = SSHSession.getJSch().getSession(user, host, 22);
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.setUserInfo((UserInfo)new SSHUserInfo());
        logger.info("Connecting to '{}' as '{}'.", (Object)host, (Object)user);
        this.session.setDaemonThread(true);
        this.session.connect();
        logger.info("Success.");
    }

    public String substituteId(String orginal) {
        return orginal.replaceAll("\\$\\{node_id}", this.id).replaceAll("\\$\\{node_host}", this.session.getHost());
    }

    public Session getSession() {
        return this.session;
    }

    private static synchronized JSch getJSch() throws JSchException {
        if (jsch == null) {
            jsch = new JSch();
            SSHSession.addIdFile(jsch, "id_rsa");
            SSHSession.addIdFile(jsch, "id_dsa");
            SSHSession.addIdFile(jsch, "id_rsa.ppk");
            jsch.setKnownHosts(new File(sshDir, "known_hosts").getAbsolutePath());
        }
        return jsch;
    }

    private static void addIdFile(JSch jsch, String fileName) throws JSchException {
        File idFile = new File(sshDir, fileName);
        if (idFile.exists()) {
            jsch.addIdentity(idFile.getAbsolutePath());
        }
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public String getUserName() {
        return this.session.getUserName();
    }

    public String getHost() {
        return this.session.getHost();
    }

    public ChannelExec openChannelExec(String exec) throws JSchException {
        return (ChannelExec)this.session.openChannel(exec);
    }
}

