/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;
import org.apache.drill.exec.store.jdbc.JdbcSubScan;

@JsonTypeName(value="jdbc-scan")
public class JdbcGroupScan
extends AbstractGroupScan {
    private final String sql;
    private final JdbcStoragePlugin plugin;
    private final double rows;

    @JsonCreator
    public JdbcGroupScan(@JsonProperty(value="sql") String sql, @JsonProperty(value="config") StoragePluginConfig config, @JsonProperty(value="rows") double rows, @JacksonInject StoragePluginRegistry plugins) throws ExecutionSetupException {
        super("");
        this.sql = sql;
        this.plugin = (JdbcStoragePlugin)plugins.getPlugin(config);
        this.rows = rows;
    }

    JdbcGroupScan(String sql, JdbcStoragePlugin plugin, double rows) {
        super("");
        this.sql = sql;
        this.plugin = plugin;
        this.rows = rows;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) throws PhysicalOperatorSetupException {
    }

    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        return new JdbcSubScan(this.sql, this.plugin);
    }

    public int getMaxParallelizationWidth() {
        return 1;
    }

    public ScanStats getScanStats() {
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (double)((long)Math.max(this.rows, 1.0)), 1.0, 1.0);
    }

    public String getSql() {
        return this.sql;
    }

    public String getDigest() {
        return this.sql + String.valueOf((Object)this.plugin.getConfig());
    }

    public StoragePluginConfig getConfig() {
        return this.plugin.getConfig();
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new JdbcGroupScan(this.sql, this.plugin, this.rows);
    }
}

