/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util.impl;

import com.google.common.collect.Maps;
import java.util.TreeMap;
import org.ojai.FieldSegment;
import org.ojai.JsonString;
import org.ojai.annotation.API;
import org.ojai.json.JsonOptions;
import org.ojai.util.impl.MutableFieldSegment;

@API.Internal
public final class ProjectionTree
implements JsonString {
    private final FieldSegment fieldSegment;
    private final ProjectionTree parent;
    TreeMap<MutableFieldSegment, ProjectionTree> children;
    private boolean isLeafSegment;

    public ProjectionTree(FieldSegment fieldSegment, ProjectionTree parent) {
        this.parent = parent;
        this.fieldSegment = fieldSegment;
        this.isLeafSegment = false;
    }

    public void addOrGetChild(FieldSegment child) {
        MutableFieldSegment segment = new MutableFieldSegment(child);
        ProjectionTree subTree = this.getChildren().get(segment);
        if (subTree == null) {
            subTree = new ProjectionTree(child, this);
            this.children.put(segment, subTree);
        }
        if (child.isLeaf()) {
            subTree.setLeafSegment();
        } else if (!subTree.isLeafSegment()) {
            subTree.addOrGetChild(child.getChild());
        }
    }

    private TreeMap<MutableFieldSegment, ProjectionTree> getChildren() {
        if (this.children == null) {
            this.children = Maps.newTreeMap();
        }
        return this.children;
    }

    public String toString() {
        return this.asJsonString();
    }

    @Override
    public String asJsonString() {
        return "{\"fieldSegment\": " + this.fieldSegment.asJsonString() + ", \"isLeafSegment\": " + this.isLeafSegment + ", \"children\": " + (this.children == null ? "[]" : this.children.values()) + "}";
    }

    @Override
    public String asJsonString(JsonOptions options) {
        return this.asJsonString();
    }

    private void setLeafSegment() {
        this.children = null;
        this.isLeafSegment = true;
    }

    public boolean isLeafSegment() {
        return this.isLeafSegment;
    }

    public ProjectionTree findChild(MutableFieldSegment fieldSegment) {
        return this.children == null ? null : this.children.get(fieldSegment);
    }

    public ProjectionTree getParent() {
        return this.parent;
    }
}

