/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util.impl;

import org.ojai.DocumentReader;
import org.ojai.FieldSegment;
import org.ojai.annotation.API;

@API.Internal
public class MutableFieldSegment
implements Comparable<MutableFieldSegment> {
    private boolean isNamed;
    private int fieldIndex;
    private String fieldName;

    public MutableFieldSegment() {
    }

    MutableFieldSegment(FieldSegment fieldSegment) {
        this.isNamed = fieldSegment.isNamed();
        if (this.isNamed) {
            this.fieldName = fieldSegment.getNameSegment().getName();
        } else {
            this.fieldIndex = fieldSegment.getIndexSegment().getIndex();
        }
    }

    public MutableFieldSegment fromReaderField(DocumentReader reader) {
        this.isNamed = reader.inMap();
        if (this.isNamed) {
            this.fieldName = reader.getFieldName();
        } else {
            this.fieldIndex = reader.getArrayIndex();
        }
        return this;
    }

    @Override
    public int compareTo(MutableFieldSegment that) {
        if (this.isNamed == that.isNamed) {
            if (this.isNamed) {
                return this.fieldName == null ? (that.fieldName == null ? 0 : -1) : this.fieldName.compareTo(that.fieldName);
            }
            return this.fieldIndex - that.fieldIndex;
        }
        return this.isNamed ? 1 : -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fieldIndex;
        result = 31 * result + (this.isNamed ? 1231 : 1237);
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableFieldSegment other = (MutableFieldSegment)obj;
        if (this.isNamed == other.isNamed) {
            return this.isNamed ? this.fieldName.equals(other.fieldName) : this.fieldIndex == other.fieldIndex;
        }
        return false;
    }

    public String toString() {
        return this.isNamed ? '`' + this.fieldName + '`' : "[" + this.fieldIndex + "]";
    }
}

