/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.json.impl.ConstantImpl;

@API.Public
public class Fields {
    public static final char SEGMENT_QUOTE_CHAR = '\"';
    private static final FieldPath[] EMPTRY_FIELDPATH_ARRAY = new FieldPath[0];

    public static String quoteFieldName(@API.NonNullable String fieldName) {
        if (fieldName.length() == 0) {
            return ConstantImpl.EMPTYSTRING;
        }
        if (fieldName.charAt(0) == '\"' && fieldName.charAt(fieldName.length() - 1) == '\"') {
            return fieldName;
        }
        for (int i = 0; i < fieldName.length(); ++i) {
            char ch = fieldName.charAt(i);
            if ("`-/ \t\n\r\f".indexOf(ch) == -1) continue;
            return '\"' + fieldName + '\"';
        }
        return fieldName;
    }

    public static String unquoteFieldName(@API.NonNullable String fieldName) {
        if (fieldName.length() == 0) {
            return ConstantImpl.EMPTYSTRING;
        }
        if (fieldName.charAt(0) == '\"' && fieldName.charAt(fieldName.length() - 1) == '\"') {
            return fieldName.substring(1, fieldName.length() - 1);
        }
        return fieldName;
    }

    public static FieldPath[] toFieldPathArray(String ... fieldPaths) {
        if (fieldPaths == null) {
            return null;
        }
        if (fieldPaths.length == 0) {
            return EMPTRY_FIELDPATH_ARRAY;
        }
        FieldPath[] fpArray = new FieldPath[fieldPaths.length];
        for (int i = 0; i < fieldPaths.length; ++i) {
            fpArray[i] = FieldPath.parseFrom(fieldPaths[i]);
        }
        return fpArray;
    }
}

