/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.JsonString;
import org.ojai.annotation.API;
import org.ojai.json.JsonOptions;
import org.ojai.util.Fields;
import org.ojai.util.impl.MutableFieldSegment;
import org.ojai.util.impl.ProjectionTree;

@API.Public
public final class FieldProjector
implements JsonString {
    private static final FieldSegment DOCUMENT_ROOT = new FieldSegment.NameSegment("$$document", null, false);
    private final ProjectionTree rootSegment;
    private DocumentReader reader;
    private ProjectionTree currentSegment;
    private ProjectionTree lastSegment;
    private MutableFieldSegment readerFieldSegment;
    private int level;
    private boolean includeField;
    private boolean includeAllChildren;

    public FieldProjector(String ... includedPaths) {
        this(Fields.toFieldPathArray((String[])Preconditions.checkNotNull((Object)includedPaths)));
    }

    public FieldProjector(FieldPath ... includedPaths) {
        this(Arrays.asList((Object[])Preconditions.checkNotNull((Object)includedPaths)));
    }

    public FieldProjector(@API.NonNullable Collection<FieldPath> includedPaths) {
        this.rootSegment = new ProjectionTree(DOCUMENT_ROOT, null);
        for (FieldPath includedPath : (Collection)Preconditions.checkNotNull(includedPaths)) {
            this.rootSegment.addOrGetChild(includedPath.getRootSegment());
        }
        this.finishConstruction();
    }

    public FieldProjector cloneWithSharedProjectionTree() {
        return new FieldProjector(this.rootSegment);
    }

    private FieldProjector(ProjectionTree rootSegment) {
        this.rootSegment = rootSegment;
        this.finishConstruction();
    }

    private void finishConstruction() {
        if (this.rootSegment == null) {
            throw new AssertionError((Object)"`rootSegment` needs to be set before calling this method");
        }
        this.level = 0;
        this.reader = null;
        this.currentSegment = this.rootSegment;
        this.lastSegment = this.rootSegment;
        this.includeField = false;
        this.includeAllChildren = false;
        this.readerFieldSegment = new MutableFieldSegment();
    }

    boolean shouldEmitEvent() {
        return this.includeField || this.includeAllChildren;
    }

    void moveTo(DocumentReader.EventType event) {
        ProjectionTree childSegment = null;
        if (this.currentSegment != null) {
            if (event == DocumentReader.EventType.END_MAP || event == DocumentReader.EventType.END_ARRAY) {
                this.includeField = true;
            } else {
                this.readerFieldSegment.fromReaderField(this.reader);
                childSegment = this.currentSegment.findChild(this.readerFieldSegment);
                this.includeField = childSegment != null && (event == DocumentReader.EventType.START_MAP || event == DocumentReader.EventType.START_ARRAY || childSegment.isLeafSegment());
            }
        }
        switch (event) {
            case START_MAP: 
            case START_ARRAY: {
                if (!this.shouldEmitEvent()) break;
                if (this.currentSegment != null) {
                    this.currentSegment = childSegment;
                    if (childSegment == null) break;
                    this.lastSegment = childSegment;
                    this.includeAllChildren = childSegment.isLeafSegment();
                    if (!this.includeAllChildren) break;
                    this.level = 1;
                    this.currentSegment = null;
                    break;
                }
                ++this.level;
                break;
            }
            case END_MAP: 
            case END_ARRAY: {
                if (!this.shouldEmitEvent()) break;
                if (this.currentSegment == null) {
                    --this.level;
                    if (this.level != 0) break;
                    this.currentSegment = this.lastSegment.getParent();
                    this.includeAllChildren = false;
                    break;
                }
                this.currentSegment = this.currentSegment.getParent();
                break;
            }
        }
    }

    FieldProjector reset(DocumentReader reader) {
        this.reader = reader;
        this.currentSegment = this.rootSegment;
        return this;
    }

    public String toString() {
        return this.asJsonString();
    }

    @Override
    public String asJsonString() {
        return this.rootSegment.toString();
    }

    @Override
    public String asJsonString(JsonOptions options) {
        return this.asJsonString();
    }
}

