/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;
import org.ojai.json.impl.JsonDocument;

public class EmptyDocumentStream
implements DocumentStream {
    private boolean isUsed;
    private boolean isClosed;

    @Override
    public Iterator<Document> iterator() {
        this.checkState();
        return new EmptyIterator<Document>();
    }

    @Override
    public void streamTo(DocumentListener listener) {
        this.checkState();
        listener.eos();
    }

    @Override
    public Iterable<DocumentReader> documentReaders() {
        this.checkState();
        return new EmptyIterable<DocumentReader>();
    }

    @Override
    public void close() throws OjaiException {
        this.isClosed = true;
    }

    private void checkState() {
        this.checkOpen();
        if (this.isUsed) {
            throw new IllegalStateException("DocumentStream has already been used once");
        }
    }

    private void checkOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("DocumentStream is already closed");
        }
    }

    @Override
    public Document getQueryPlan() {
        return new JsonDocument();
    }

    private static class EmptyIterable<T>
    implements Iterable<T> {
        private EmptyIterable() {
        }

        @Override
        public Iterator<T> iterator() {
            return new EmptyIterator();
        }
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }
    }
}

