/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.FieldProjector;

@API.Public
public class DocumentReaderWithProjection
implements DocumentReader {
    private final DocumentReader reader;
    private final FieldProjector projector;

    public DocumentReaderWithProjection(@API.NonNullable DocumentReader reader, @API.NonNullable FieldProjector projection) {
        this.reader = (DocumentReader)Preconditions.checkNotNull((Object)reader);
        this.projector = ((FieldProjector)Preconditions.checkNotNull((Object)projection)).reset(reader);
    }

    @Override
    public DocumentReader.EventType next() {
        DocumentReader.EventType event;
        while ((event = this.reader.next()) != null) {
            if (event == DocumentReader.EventType.START_MAP && this.reader.inMap() && this.reader.getFieldName() == null) {
                return event;
            }
            this.projector.moveTo(event);
            if (this.projector.shouldEmitEvent()) {
                return event;
            }
            this.reader.skipChildren();
        }
        return null;
    }

    @Override
    public DocumentReader skipChildren() {
        this.reader.skipChildren();
        return this;
    }

    @Override
    public boolean inMap() {
        return this.reader.inMap();
    }

    @Override
    public String getFieldName() {
        return this.reader.getFieldName();
    }

    @Override
    public int getArrayIndex() {
        return this.reader.getArrayIndex();
    }

    @Override
    public byte getByte() {
        return this.reader.getByte();
    }

    @Override
    public short getShort() {
        return this.reader.getShort();
    }

    @Override
    public int getInt() {
        return this.reader.getInt();
    }

    @Override
    public long getLong() {
        return this.reader.getLong();
    }

    @Override
    public float getFloat() {
        return this.reader.getFloat();
    }

    @Override
    public double getDouble() {
        return this.reader.getDouble();
    }

    @Override
    public BigDecimal getDecimal() {
        return this.reader.getDecimal();
    }

    @Override
    public int getDecimalPrecision() {
        return this.reader.getDecimalPrecision();
    }

    @Override
    public int getDecimalScale() {
        return this.reader.getDecimalScale();
    }

    @Override
    public int getDecimalValueAsInt() {
        return this.reader.getDecimalValueAsInt();
    }

    @Override
    public long getDecimalValueAsLong() {
        return this.reader.getDecimalValueAsLong();
    }

    @Override
    public ByteBuffer getDecimalValueAsBytes() {
        return this.reader.getDecimalValueAsBytes();
    }

    @Override
    public boolean getBoolean() {
        return this.reader.getBoolean();
    }

    @Override
    public String getString() {
        return this.reader.getString();
    }

    @Override
    public long getTimestampLong() {
        return this.reader.getTimestampLong();
    }

    @Override
    public OTimestamp getTimestamp() {
        return this.reader.getTimestamp();
    }

    @Override
    public int getDateInt() {
        return this.reader.getDateInt();
    }

    @Override
    public ODate getDate() {
        return this.reader.getDate();
    }

    @Override
    public int getTimeInt() {
        return this.reader.getTimeInt();
    }

    @Override
    public OTime getTime() {
        return this.reader.getTime();
    }

    @Override
    public OInterval getInterval() {
        return this.reader.getInterval();
    }

    @Override
    public int getIntervalDays() {
        return this.reader.getIntervalDays();
    }

    @Override
    public long getIntervalMillis() {
        return this.reader.getIntervalMillis();
    }

    @Override
    public ByteBuffer getBinary() {
        return this.reader.getBinary();
    }

    @Override
    public DocumentReader.EventType getCurrentEvent() {
        return this.reader.getCurrentEvent();
    }
}

