/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.store;

import java.math.BigDecimal;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;

@API.Public
@API.NotThreadSafe
public interface DocumentStore
extends AutoCloseable {
    public boolean isReadOnly();

    public void flush() throws StoreException;

    public void beginTrackingWrites() throws StoreException;

    public void beginTrackingWrites(@API.NonNullable String var1) throws StoreException;

    public String endTrackingWrites() throws StoreException;

    public void clearTrackedWrites() throws StoreException;

    public Document findById(String var1) throws StoreException;

    public Document findById(Value var1) throws StoreException;

    public Document findById(String var1, String ... var2) throws StoreException;

    public Document findById(String var1, FieldPath ... var2) throws StoreException;

    public Document findById(Value var1, String ... var2) throws StoreException;

    public Document findById(Value var1, FieldPath ... var2) throws StoreException;

    public Document findById(String var1, QueryCondition var2) throws StoreException;

    public Document findById(Value var1, QueryCondition var2) throws StoreException;

    public Document findById(String var1, QueryCondition var2, String ... var3) throws StoreException;

    public Document findById(String var1, QueryCondition var2, FieldPath ... var3) throws StoreException;

    public Document findById(Value var1, QueryCondition var2, String ... var3) throws StoreException;

    public Document findById(Value var1, QueryCondition var2, FieldPath ... var3) throws StoreException;

    public DocumentStream find() throws StoreException;

    public DocumentStream findQuery(@API.NonNullable Query var1) throws StoreException;

    public DocumentStream findQuery(@API.NonNullable String var1) throws StoreException;

    public DocumentStream find(String ... var1) throws StoreException;

    public DocumentStream find(FieldPath ... var1) throws StoreException;

    public DocumentStream find(@API.NonNullable QueryCondition var1) throws StoreException;

    public DocumentStream find(@API.NonNullable QueryCondition var1, String ... var2) throws StoreException;

    public DocumentStream find(@API.NonNullable QueryCondition var1, FieldPath ... var2) throws StoreException;

    public void insertOrReplace(@API.NonNullable Document var1) throws StoreException;

    public void insertOrReplace(@API.NonNullable String var1, @API.NonNullable Document var2) throws StoreException;

    public void insertOrReplace(@API.NonNullable Value var1, @API.NonNullable Document var2) throws StoreException;

    public void insertOrReplace(@API.NonNullable Document var1, @API.NonNullable FieldPath var2) throws StoreException;

    public void insertOrReplace(@API.NonNullable Document var1, @API.NonNullable String var2) throws StoreException;

    public void insertOrReplace(@API.NonNullable DocumentStream var1) throws MultiOpException;

    public void insertOrReplace(@API.NonNullable DocumentStream var1, @API.NonNullable FieldPath var2) throws MultiOpException;

    public void insertOrReplace(@API.NonNullable DocumentStream var1, @API.NonNullable String var2) throws MultiOpException;

    public void update(@API.NonNullable String var1, @API.NonNullable DocumentMutation var2) throws StoreException;

    public void update(@API.NonNullable Value var1, @API.NonNullable DocumentMutation var2) throws StoreException;

    public void delete(@API.NonNullable String var1) throws StoreException;

    public void delete(@API.NonNullable Value var1) throws StoreException;

    public void delete(@API.NonNullable Document var1) throws StoreException;

    public void delete(@API.NonNullable Document var1, @API.NonNullable FieldPath var2) throws StoreException;

    public void delete(@API.NonNullable Document var1, @API.NonNullable String var2) throws StoreException;

    public void delete(@API.NonNullable DocumentStream var1) throws MultiOpException;

    public void delete(@API.NonNullable DocumentStream var1, @API.NonNullable FieldPath var2) throws MultiOpException;

    public void delete(@API.NonNullable DocumentStream var1, @API.NonNullable String var2) throws MultiOpException;

    public void insert(@API.NonNullable String var1, @API.NonNullable Document var2) throws StoreException;

    public void insert(@API.NonNullable Value var1, @API.NonNullable Document var2) throws StoreException;

    public void insert(@API.NonNullable Document var1) throws StoreException;

    public void insert(@API.NonNullable Document var1, @API.NonNullable FieldPath var2) throws StoreException;

    public void insert(@API.NonNullable Document var1, @API.NonNullable String var2) throws StoreException;

    public void insert(@API.NonNullable DocumentStream var1) throws MultiOpException;

    public void insert(@API.NonNullable DocumentStream var1, @API.NonNullable FieldPath var2) throws MultiOpException;

    public void insert(@API.NonNullable DocumentStream var1, @API.NonNullable String var2) throws MultiOpException;

    public void replace(@API.NonNullable String var1, @API.NonNullable Document var2) throws StoreException;

    public void replace(@API.NonNullable Value var1, @API.NonNullable Document var2) throws StoreException;

    public void replace(@API.NonNullable Document var1) throws StoreException;

    public void replace(@API.NonNullable Document var1, @API.NonNullable FieldPath var2) throws StoreException;

    public void replace(@API.NonNullable Document var1, @API.NonNullable String var2) throws StoreException;

    public void replace(@API.NonNullable DocumentStream var1) throws MultiOpException;

    public void replace(@API.NonNullable DocumentStream var1, @API.NonNullable FieldPath var2) throws MultiOpException;

    public void replace(@API.NonNullable DocumentStream var1, @API.NonNullable String var2) throws MultiOpException;

    public void increment(@API.NonNullable String var1, @API.NonNullable String var2, byte var3) throws StoreException;

    public void increment(@API.NonNullable String var1, @API.NonNullable String var2, short var3) throws StoreException;

    public void increment(@API.NonNullable String var1, @API.NonNullable String var2, int var3) throws StoreException;

    public void increment(@API.NonNullable String var1, @API.NonNullable String var2, long var3) throws StoreException;

    public void increment(@API.NonNullable String var1, @API.NonNullable String var2, float var3) throws StoreException;

    public void increment(@API.NonNullable String var1, @API.NonNullable String var2, double var3) throws StoreException;

    public void increment(@API.NonNullable String var1, @API.NonNullable String var2, @API.NonNullable BigDecimal var3) throws StoreException;

    public void increment(@API.NonNullable Value var1, @API.NonNullable String var2, byte var3) throws StoreException;

    public void increment(@API.NonNullable Value var1, @API.NonNullable String var2, short var3) throws StoreException;

    public void increment(@API.NonNullable Value var1, @API.NonNullable String var2, int var3) throws StoreException;

    public void increment(@API.NonNullable Value var1, @API.NonNullable String var2, long var3) throws StoreException;

    public void increment(@API.NonNullable Value var1, @API.NonNullable String var2, float var3) throws StoreException;

    public void increment(@API.NonNullable Value var1, @API.NonNullable String var2, double var3) throws StoreException;

    public void increment(@API.NonNullable Value var1, @API.NonNullable String var2, @API.NonNullable BigDecimal var3) throws StoreException;

    public boolean checkAndMutate(@API.NonNullable String var1, @API.NonNullable QueryCondition var2, @API.NonNullable DocumentMutation var3) throws StoreException;

    public boolean checkAndMutate(@API.NonNullable Value var1, @API.NonNullable QueryCondition var2, @API.NonNullable DocumentMutation var3) throws StoreException;

    public boolean checkAndDelete(@API.NonNullable String var1, @API.NonNullable QueryCondition var2) throws StoreException;

    public boolean checkAndDelete(@API.NonNullable Value var1, @API.NonNullable QueryCondition var2) throws StoreException;

    public boolean checkAndReplace(@API.NonNullable String var1, @API.NonNullable QueryCondition var2, @API.NonNullable Document var3) throws StoreException;

    public boolean checkAndReplace(@API.NonNullable Value var1, @API.NonNullable QueryCondition var2, @API.NonNullable Document var3) throws StoreException;

    @Override
    public void close() throws StoreException;
}

