/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.json.Events;
import org.ojai.json.impl.DelegatingJsonDocumentReader;
import org.ojai.json.impl.JsonDocumentStream;
import org.ojai.json.impl.JsonStreamDocumentReader;
import org.ojai.json.impl.TypeMappedJsonDocumentReader;

class JsonDocumentReaderIterable
implements Iterable<DocumentReader> {
    private final JsonDocumentStream jsonDocumentStream;
    private final Map<FieldPath, Value.Type> fieldPathTypeMap;
    private final Events.Delegate eventDelegate;

    JsonDocumentReaderIterable(JsonDocumentStream documentStream) {
        this.jsonDocumentStream = documentStream;
        this.fieldPathTypeMap = documentStream.getFieldPathTypeMap();
        this.eventDelegate = documentStream.getEventDelegate();
    }

    @Override
    public Iterator<DocumentReader> iterator() {
        return new Iterator<DocumentReader>(){
            private JsonStreamDocumentReader lastReader;
            private JsonStreamDocumentReader currentReader;
            private boolean eos = false;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DocumentReader next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReader = this.currentReader;
                this.currentReader = null;
                return this.lastReader;
            }

            @Override
            public boolean hasNext() {
                if (this.lastReader != null) {
                    this.lastReader.readFully();
                    this.lastReader = null;
                }
                if (!this.eos && this.currentReader == null) {
                    this.currentReader = JsonDocumentReaderIterable.this.eventDelegate != null ? new DelegatingJsonDocumentReader(JsonDocumentReaderIterable.this.jsonDocumentStream, JsonDocumentReaderIterable.this.eventDelegate) : (JsonDocumentReaderIterable.this.fieldPathTypeMap != null ? new TypeMappedJsonDocumentReader(JsonDocumentReaderIterable.this.jsonDocumentStream, JsonDocumentReaderIterable.this.fieldPathTypeMap) : new JsonStreamDocumentReader(JsonDocumentReaderIterable.this.jsonDocumentStream));
                    this.eos = this.currentReader.eor();
                }
                return !this.eos;
            }
        };
    }
}

