/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.joda.chrono;

import java.util.Locale;
import org.ojai.joda.DateTimeFieldType;
import org.ojai.joda.DurationField;
import org.ojai.joda.DurationFieldType;
import org.ojai.joda.IllegalFieldValueException;
import org.ojai.joda.field.BaseDateTimeField;
import org.ojai.joda.field.FieldUtils;
import org.ojai.joda.field.UnsupportedDurationField;

final class BasicSingleEraDateTimeField
extends BaseDateTimeField {
    private static final int ERA_VALUE = 1;
    private final String iEraText;

    BasicSingleEraDateTimeField(String string) {
        super(DateTimeFieldType.era());
        this.iEraText = string;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long l) {
        return 1;
    }

    public long set(long l, int n) {
        FieldUtils.verifyValueBounds(this, n, 1, 1);
        return l;
    }

    public long set(long l, String string, Locale locale) {
        if (!this.iEraText.equals(string) && !"1".equals(string)) {
            throw new IllegalFieldValueException(DateTimeFieldType.era(), string);
        }
        return l;
    }

    public long roundFloor(long l) {
        return Long.MIN_VALUE;
    }

    public long roundCeiling(long l) {
        return Long.MAX_VALUE;
    }

    public long roundHalfFloor(long l) {
        return Long.MIN_VALUE;
    }

    public long roundHalfCeiling(long l) {
        return Long.MIN_VALUE;
    }

    public long roundHalfEven(long l) {
        return Long.MIN_VALUE;
    }

    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 1;
    }

    public String getAsText(int n, Locale locale) {
        return this.iEraText;
    }

    public int getMaximumTextLength(Locale locale) {
        return this.iEraText.length();
    }
}

