/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.impl;

import java.io.IOException;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.ClientUtil;
import org.apache.kerby.kerberos.kerb.client.KrbSetting;
import org.apache.kerby.kerberos.kerb.client.impl.AbstractInternalKrbClient;
import org.apache.kerby.kerberos.kerb.client.impl.DefaultKrbHandler;
import org.apache.kerby.kerberos.kerb.client.request.AsRequest;
import org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.client.request.TgsRequest;
import org.apache.kerby.kerberos.kerb.transport.KrbNetwork;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;

public class DefaultInternalKrbClient
extends AbstractInternalKrbClient {
    private DefaultKrbHandler krbHandler;
    private KrbTransport transport;

    public DefaultInternalKrbClient(KrbSetting krbSetting) {
        super(krbSetting);
    }

    @Override
    public void init() throws KrbException {
        super.init();
        this.krbHandler = new DefaultKrbHandler();
        this.krbHandler.init(this.getContext());
    }

    private void doRequest(KdcRequest request) throws KrbException {
        try {
            TransportPair tpair = ClientUtil.getTransportPair(this.getSetting());
            KrbNetwork network = new KrbNetwork();
            network.setSocketTimeout(this.getSetting().getTimeout());
            this.transport = network.connect(tpair);
            request.setSessionData(this.transport);
            this.krbHandler.handleRequest(request);
        }
        catch (IOException e) {
            throw new KrbException("Failed to create transport", (Throwable)e);
        }
        finally {
            this.transport.release();
        }
    }

    @Override
    protected TgtTicket doRequestTgt(AsRequest tgtTktReq) throws KrbException {
        this.doRequest(tgtTktReq);
        return tgtTktReq.getTicket();
    }

    @Override
    protected SgtTicket doRequestSgt(TgsRequest ticketReq) throws KrbException {
        this.doRequest(ticketReq);
        return ticketReq.getSgt();
    }
}

