/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.google.common.io.BaseEncoding;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ojai.Value;
import org.ojai.annotation.API;

@API.Internal
public class SqlHelper {
    private static final String BINARY_TAG = "$ojai_binary$";
    private static final int BINARY_TAG_LEN = "$ojai_binary$".length();
    private static final int MD5_PREFIX_LEN = 4;
    private static final int TOTAL_TAG_LEN = BINARY_TAG_LEN + 4;
    private static final BaseEncoding CODEC = BaseEncoding.base64();

    public static String encodeBinaryAsString(ByteBuffer binaryValue) {
        byte[] byteArray = Bytes.getBytes((ByteBuffer)binaryValue);
        String md5Digest = SqlHelper.md5_prefix(byteArray);
        return BINARY_TAG + md5Digest + CODEC.encode(Bytes.getBytes((ByteBuffer)binaryValue));
    }

    private static String md5_prefix(byte[] byteArray) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md5Digest = md5.digest(byteArray);
            String bigInt = new BigInteger(1, md5Digest).toString(16);
            return bigInt.substring(0, 4);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DBException(e);
        }
    }

    public static Value decodeStringAsValue(String sqlStringValue) {
        if (sqlStringValue.length() >= TOTAL_TAG_LEN && sqlStringValue.startsWith(BINARY_TAG)) {
            String md5Prefix = sqlStringValue.substring(BINARY_TAG_LEN, TOTAL_TAG_LEN);
            String base64String = sqlStringValue.substring(TOTAL_TAG_LEN);
            try {
                byte[] byteArray = CODEC.decode((CharSequence)base64String);
                String md5Digest = SqlHelper.md5_prefix(byteArray);
                if (md5Digest.equals(md5Prefix)) {
                    return DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(byteArray));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return DBValueBuilderImpl.KeyValueBuilder.initFrom(sqlStringValue);
    }
}

