/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import org.ojai.exceptions.TypeException;

public class KeyValueSizeHelper {
    static int getValueSize(KeyValue kv) {
        switch (kv.getType()) {
            case MAP: 
            case ARRAY: {
                return Integer.MAX_VALUE;
            }
            case BINARY: {
                return kv.getBinaryInternal().remaining();
            }
            case BOOLEAN: {
                return 0;
            }
            case BYTE: {
                return 1;
            }
            case DATE: {
                return KeyValueSizeHelper.varLongSize(kv);
            }
            case DECIMAL: {
                return BigDecimalSizeDescriptor.getSerializedSize(kv.getDecimal());
            }
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case INT: {
                return 4;
            }
            case INTERVAL: {
                return KeyValueSizeHelper.varLongSize(kv);
            }
            case LONG: {
                return 8;
            }
            case NULL: {
                return 0;
            }
            case SHORT: {
                return 2;
            }
            case STRING: {
                return Bytes.toBytes((String)kv.getString()).length;
            }
            case TIME: {
                return KeyValueSizeHelper.varLongSize(kv);
            }
            case TIMESTAMP: {
                return KeyValueSizeHelper.varLongSize(kv);
            }
        }
        throw new TypeException("Unknown type " + kv.getType());
    }

    private static int varLongSize(KeyValue kv) {
        long v = kv.getPrimValue();
        if (v < 0L) {
            return 8;
        }
        if (v <= 255L) {
            return 1;
        }
        if (v <= 65535L) {
            return 2;
        }
        if (v <= 0xFFFFFFFFL) {
            return 4;
        }
        return 8;
    }
}

