/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueWithTS;
import com.mapr.db.rowcol.TimeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.ojai.FieldSegment;
import org.ojai.Value;

public class DBList
extends KeyValueWithTS
implements List<Object> {
    private boolean isAbsoluteIndexType;
    List<KeyValue> list;
    Map<Integer, KeyValue> map;

    public DBList(InsertContext.OpType t) {
        super(Value.Type.ARRAY);
        if (t == InsertContext.OpType.NONE) {
            this.isAbsoluteIndexType = false;
            this.objValue = this.list = new ArrayList<KeyValue>();
        } else {
            this.isAbsoluteIndexType = true;
            this.map = new TreeMap<Integer, KeyValue>();
        }
    }

    public boolean IsAbsoluteIndexType() {
        return this.isAbsoluteIndexType;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(DBValueBuilderImpl.KeyValueBuilder.initFromObject(o));
    }

    @Override
    public Iterator<Object> iterator() {
        final Iterator<KeyValue> itr = this.list.iterator();
        return new Iterator<Object>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                KeyValue kv = (KeyValue)itr.next();
                return kv != null ? kv.getObject() : null;
            }

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }
        };
    }

    @Override
    public Object[] toArray() {
        ArrayList<Object> objs = new ArrayList<Object>(this.list.size());
        for (KeyValue kv : this.list) {
            objs.add(kv.getObject());
        }
        return objs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return a;
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.list.contains(DBValueBuilderImpl.KeyValueBuilder.initFromObject(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(int index) {
        KeyValue kv = this.getKeyValueAt(index);
        if (kv == null) {
            return null;
        }
        return kv.getObject();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(DBValueBuilderImpl.KeyValueBuilder.initFromObject(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(DBValueBuilderImpl.KeyValueBuilder.initFromObject(o));
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new MapRDBListIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new MapRDBListIterator(index);
    }

    public Iterator<Object> getSparseListIterator() {
        return new SparseListIterator();
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (KeyValue v : this.list.subList(fromIndex, toIndex)) {
            l.add(v.getObject());
        }
        return l;
    }

    public void insert(int index, KeyValue child, InsertContext ctx) {
        child.setIsArrayElement(true);
        if (this.IsAbsoluteIndexType()) {
            this.map.put(index, child);
        } else {
            int size = this.list.size();
            if (index >= size) {
                while (index > size++) {
                    KeyValue nullChild = DBValueBuilderImpl.KeyValueBuilder.initFromNull();
                    nullChild.setIsArrayElement(true);
                    nullChild.setOpTypeAndFlags(ctx, true);
                    this.list.add(nullChild);
                }
                this.list.add(child);
            } else {
                this.list.set(index, child);
            }
        }
    }

    public void insertValueWithFlags(int index, KeyValue child) {
        InsertContext ctx = new InsertContext();
        this.setRootFlags(ctx);
        child.setOpTypeAndFlags(ctx, true);
        this.insert(index, child, ctx);
    }

    public void removeFromList(int index) {
        assert (!this.IsAbsoluteIndexType()) : "remove operation must be called only on the associative type of array";
        if (index >= this.list.size()) {
            return;
        }
        this.list.remove(index);
    }

    public void createOrInsert(Iterator<FieldSegment> iter, KeyValue inKeyValue, InsertContext ctx) {
        boolean isAssocIndex;
        ArrayIndexDescriptor.ArrayIndexType arrayIndexType;
        FieldSegment field = iter.next();
        int index = field.getIndexSegment().getIndex();
        ArrayIndexDescriptor.ArrayIndexType arrayIndexType2 = arrayIndexType = this.IsAbsoluteIndexType() ? ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE : ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ASSOCIATIVE;
        if (this.IsAbsoluteIndexType()) {
            ctx.setHasAbsArrayIndex(true);
        }
        assert (ctx.getOpType() != InsertContext.OpType.NONE || !this.IsAbsoluteIndexType()) : "if operation type is none then the array must be of associative type of index";
        assert (ctx.getOpType() == InsertContext.OpType.NONE || this.IsAbsoluteIndexType()) : "if operation type is none then the array must be of associative type of index";
        KeyValue oldKeyValue = this.getKeyValueAt(index);
        if (field.isLastPath()) {
            inKeyValue.setOpTypeAndFlags(ctx, true);
            this.insert(index, inKeyValue, ctx);
            return;
        }
        if (field.isMap()) {
            if (oldKeyValue == null || oldKeyValue.getType() != Value.Type.MAP) {
                DBDocumentImpl newRecord = new DBDocumentImpl();
                newRecord.createOrInsert(iter, inKeyValue, ctx);
                newRecord.setOpTypeAndFlags(ctx, false);
                this.insert(index, newRecord, ctx);
                return;
            }
            if (ctx.getOpType() != InsertContext.OpType.NONE && oldKeyValue.getOpType() != InsertContext.OpType.NONE) {
                DBDocumentImpl newRecord = new DBDocumentImpl();
                newRecord.createOrInsert(iter, inKeyValue, ctx);
                newRecord.setOpTypeAndFlags(ctx, false);
                this.insert(index, newRecord, ctx);
                return;
            }
            DBDocumentImpl newRecord = (DBDocumentImpl)oldKeyValue;
            newRecord.setOpTypeAndFlags(ctx, false);
            newRecord.createOrInsert(iter, inKeyValue, ctx);
            return;
        }
        if (oldKeyValue == null || oldKeyValue.getType() != Value.Type.ARRAY) {
            DBList newList = new DBList(ctx.getOpType());
            newList.createOrInsert(iter, inKeyValue, ctx);
            newList.setOpTypeAndFlags(ctx, false);
            this.insert(index, newList, ctx);
            return;
        }
        InsertContext.OpType ctxOpType = ctx.getOpType();
        boolean bl = isAssocIndex = !((DBList)oldKeyValue).IsAbsoluteIndexType();
        if (ctxOpType == InsertContext.OpType.NONE && !isAssocIndex || ctxOpType != InsertContext.OpType.NONE && isAssocIndex || oldKeyValue.getOpType() != InsertContext.OpType.NONE) {
            DBList newList = new DBList(ctx.getOpType());
            newList.createOrInsert(iter, inKeyValue, ctx);
            newList.setOpTypeAndFlags(ctx, false);
            this.insert(index, newList, ctx);
            return;
        }
        DBList newList = (DBList)oldKeyValue;
        newList.createOrInsert(iter, inKeyValue, ctx);
        newList.setOpTypeAndFlags(ctx, false);
        this.insert(index, newList, ctx);
    }

    public void addToDBListAndSetOpTypeAndFlags(KeyValue keyValue) {
        keyValue.setOpTypeAndFlags(null, false);
        this.addToDBList(keyValue);
    }

    public void addToDBList(KeyValue keyValue) {
        assert (!this.IsAbsoluteIndexType()) : "This should be called only during Record API";
        this.insert(this.list.size(), keyValue, null);
    }

    public void addToDBListWithFlags(KeyValue keyValue) {
        assert (!this.IsAbsoluteIndexType()) : "This should be called only during Record API";
        this.insertValueWithFlags(this.list.size(), keyValue);
    }

    public void delete(Iterator<FieldSegment> iter) {
        FieldSegment field = iter.next();
        if (field == null) {
            return;
        }
        int index = field.getIndexSegment().getIndex();
        KeyValue kv = this.getKeyValueAt(index);
        if (kv == null) {
            return;
        }
        if (field.isLastPath()) {
            this.removeFromList(index);
            return;
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return;
            }
            ((DBDocumentImpl)kv).delete(iter);
            return;
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return;
        }
        DBList l = (DBList)kv;
        l.delete(iter);
    }

    KeyValue getKeyValueAt(int index) {
        if (this.isAbsoluteIndexType) {
            return this.map.get(index);
        }
        return this.list.size() <= index ? null : this.list.get(index);
    }

    KeyValue getKeyValueAt(Iterator<FieldSegment> iter) {
        FieldSegment field = iter.next();
        if (field == null) {
            return null;
        }
        int index = field.getIndexSegment().getIndex();
        KeyValue kv = this.getKeyValueAt(index);
        if (kv == null) {
            return null;
        }
        if (field.isLastPath()) {
            return kv;
        }
        if (field.isMap()) {
            if (kv.getType() != Value.Type.MAP) {
                return null;
            }
            return ((DBDocumentImpl)kv).getKeyValueAt(iter);
        }
        if (kv.getType() != Value.Type.ARRAY) {
            return null;
        }
        return ((DBList)kv).getKeyValueAt(iter);
    }

    @Override
    public DBList shallowCopy() {
        if (!this.isAbsoluteIndexType) {
            DBList rec = new DBList(InsertContext.OpType.NONE);
            rec.list = this.list;
            rec.objValue = this.objValue;
            rec.primValue = this.primValue;
            return rec;
        }
        return (DBList)super.shallowCopy();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append('[');
        for (Value value : this.list) {
            if (value != null) {
                sb.append(value.toString()).append(", ");
                continue;
            }
            sb.append("null").append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        return sb.append(']').toString();
    }

    @Override
    public String toStringWithTimestamp() {
        StringBuilder sb = new StringBuilder().append('[');
        for (Value value : this.list) {
            KeyValueWithTS kv = (KeyValueWithTS)value;
            sb.append("{").append("\"_index\": ").append(ArrayIndexDescriptor.toStringWithTimestamp(kv)).append(", ").append("\"_timestamp\":").append(TimeDescriptor.toStringWithTimestamp(kv)).append(", ").append("\"_value\":").append(kv.toStringWithTimestamp()).append("}").append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        return sb.append(']').toString();
    }

    public void addNullToList() {
        this.list.add(null);
    }

    class SparseListIterator
    implements ListIterator<Object> {
        final ListIterator<KeyValue> dbListIter;
        private int cursorPrevious;

        public SparseListIterator() {
            this.dbListIter = DBList.this.list.listIterator();
            this.cursorPrevious = -1;
        }

        @Override
        public boolean hasNext() {
            return this.dbListIter.nextIndex() < DBList.this.list.size();
        }

        @Override
        public Object next() {
            this.cursorPrevious = this.dbListIter.nextIndex();
            KeyValue kv = this.dbListIter.next();
            while (kv == null && this.dbListIter.hasNext()) {
                this.cursorPrevious = this.dbListIter.nextIndex();
                kv = this.dbListIter.next();
            }
            if (kv != null) {
                return kv.getObject();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            return this.cursorPrevious;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }
    }

    class MapRDBListIterator
    implements ListIterator<Object> {
        final ListIterator<KeyValue> iter;

        public MapRDBListIterator(int index) {
            this.iter = DBList.this.list.listIterator(index);
        }

        public MapRDBListIterator() {
            this.iter = DBList.this.list.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Object next() {
            KeyValue kv = this.iter.next();
            if (kv != null) {
                return kv.getObject();
            }
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public Object previous() {
            KeyValue kv = this.iter.previous();
            if (kv != null) {
                return kv.getObject();
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }
    }
}

