/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponentArray;
import com.mapr.db.indexrowkeyfmt.Null;
import java.util.Arrays;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class IndexRowKeyDecoder {
    private byte[] encodedData_ = null;
    private boolean[] descendingOrder_ = null;
    private byte[] primaryKey_ = null;
    private IndexRowKeyComponentArray indexRowKeyComponentArray_ = null;
    private boolean isHashed_;
    private static final boolean missingAndNullFirst = false;
    private static Null n = new Null();
    private static String s = new String("");
    private static byte[] ba = new byte[1];
    private static ODate d = new ODate(0L);
    private static OTimestamp ts = new OTimestamp(0L);
    private static OTime t = new OTime(0L);
    private static Error e = new Error(0);
    private static final int ROW_KEY_TYPE_ENCODING_SIZE = 1;
    private static final int INDEX_HASH_ENCODING_SIZE = 2;

    public IndexRowKeyDecoder() {
        this.isHashed_ = false;
    }

    public IndexRowKeyDecoder(boolean isHashed) {
        this.isHashed_ = isHashed;
    }

    public void init(boolean[] descendingOrder) {
        this.indexRowKeyComponentArray_ = new IndexRowKeyComponentArray(descendingOrder.length, false);
        this.descendingOrder_ = descendingOrder;
    }

    private boolean isErrorEncoding(byte[] encodedData) {
        return encodedData[1 + (this.isHashed_ ? 2 : 0)] == -1;
    }

    public void setRowKey(byte[] encodedData) {
        this.encodedData_ = encodedData;
        if (this.isErrorEncoding(encodedData)) {
            this.indexRowKeyComponentArray_.init(1);
        }
    }

    private IndexRowKeyComponent getComponentAwareOfItsLocation(int idx, int offset, boolean descendingOrder) {
        byte firstByte = this.encodedData_[offset];
        IndexRowKeyComponent component = null;
        switch (firstByte) {
            case -5: 
            case 4: {
                this.indexRowKeyComponentArray_.set(idx, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -6: 
            case 5: {
                this.indexRowKeyComponentArray_.set(idx, n, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -8: 
            case -7: 
            case 6: 
            case 7: {
                this.indexRowKeyComponentArray_.set(idx, false, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -9: 
            case 8: {
                this.indexRowKeyComponentArray_.set(idx, s.getBytes(), descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -10: 
            case 9: {
                this.indexRowKeyComponentArray_.set(idx, ba, ba.length, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -11: 
            case 10: {
                this.indexRowKeyComponentArray_.set(idx, d, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -13: 
            case 12: {
                this.indexRowKeyComponentArray_.set(idx, ts, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -12: 
            case 11: {
                this.indexRowKeyComponentArray_.set(idx, t, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            case -1: {
                this.indexRowKeyComponentArray_.init(1);
                this.indexRowKeyComponentArray_.set(idx, e, descendingOrder);
                component = this.indexRowKeyComponentArray_.get(idx);
                break;
            }
            default: {
                if (90 <= firstByte || firstByte <= -91 || 90 <= firstByte || firstByte <= -91 || firstByte == -80 || firstByte == 79 || firstByte == -79 || firstByte == 78) {
                    this.indexRowKeyComponentArray_.set(idx, 0, descendingOrder);
                    component = this.indexRowKeyComponentArray_.get(idx);
                    break;
                }
                return null;
            }
        }
        if (component != null) {
            if (component.calculateEncodingSize(this.encodedData_, offset) == 0) {
                return null;
            }
            assert (this.encodedData_.length >= this.indexRowKeyComponentArray_.getNumComponents());
            component.setOffset(offset);
            component.setOrigType(this.encodedData_[this.encodedData_.length - this.indexRowKeyComponentArray_.getNumComponents() + idx]);
        }
        return component;
    }

    public IndexRowKeyComponent getComponent(int idx) throws IllegalArgumentException {
        int decodedDataSize;
        IndexRowKeyComponent irkc = this.indexRowKeyComponentArray_.get(idx);
        if (irkc == null) {
            int i;
            int offset = 1;
            if (this.isHashed_) {
                offset += 2;
            }
            if ((i = this.indexRowKeyComponentArray_.getInitializedLeftSibling(idx)) >= 0) {
                irkc = this.indexRowKeyComponentArray_.get(i);
                offset = irkc.getOffset() + irkc.getFullEncodingSize();
            }
            while (++i <= idx) {
                irkc = this.getComponentAwareOfItsLocation(i, offset, this.descendingOrder_[i]);
                if (irkc == null) {
                    throw new IllegalArgumentException("Unable to decode row key component at offset " + offset);
                }
                offset += irkc.getFullEncodingSize();
            }
        }
        if (!irkc.isDecoded() && (decodedDataSize = irkc.decode(this.encodedData_, irkc.getOffset(), irkc.getEncodingSize())) < 0) {
            throw new IllegalArgumentException("Unable to decode row key component at offset " + irkc.getOffset());
        }
        return irkc;
    }

    public byte[] getPrimaryTableRowKey() {
        if (this.primaryKey_ == null) {
            int numComponents = this.indexRowKeyComponentArray_.getNumComponents();
            IndexRowKeyComponent irkc = this.getComponent(numComponents - 1);
            if (irkc == null) {
                return null;
            }
            int offset = irkc.getOffset() + irkc.getFullEncodingSize();
            this.primaryKey_ = Arrays.copyOfRange(this.encodedData_, offset, this.encodedData_.length - numComponents);
        }
        return this.primaryKey_;
    }
}

