/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.DBDocumentStream;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.util.Fids;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONStringer;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.json.JsonOptions;
import org.ojai.store.DocumentMutation;
import org.ojai.store.OpListener;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.MultiOpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
public class MapRDBIndexImpl
extends BaseJsonTable {
    private static Logger logger = LoggerFactory.getLogger(MapRDBIndexImpl.class);
    protected final Dbserver.SIndexInfo indexInfo;
    protected final List<IndexFieldDesc> indexedFieldList;
    protected final Collection<IndexFieldDesc> includedFieldList;
    protected final Map<Integer, Dbserver.ColumnFamilyAttr> cfIdAttributesMap;
    protected final Map<Integer, FieldPath> fpIdxTofpMap;
    protected final Path tablePath;
    protected final String siFid;
    protected final String indexName;
    protected final boolean isHashed;
    protected final boolean missingAndNullFirst;
    protected List<Dbserver.ColumnFamilyAttr> cfAttrs;

    public MapRDBIndexImpl(Configuration config, Path primaryTablePath, String secondaryIndexFid, String secondaryIndexName) throws DBException, TableNotFoundException {
        super(config);
        try {
            this.maprTable = new MapRHTable();
            this.tablePath = primaryTablePath;
            this.siFid = secondaryIndexFid;
            this.indexName = secondaryIndexName;
            this.maprTable.init(config, primaryTablePath, secondaryIndexName, secondaryIndexFid);
            this.indexInfo = this.getIndexInfo(primaryTablePath, secondaryIndexFid, secondaryIndexName);
            this.includedFieldList = null;
            this.isHashed = this.indexInfo.getHashed();
            this.cfAttrs = this.maprTable.getMapRFS().listColumnFamily(primaryTablePath, false, true);
            this.cfIdAttributesMap = this.getPrimaryTableFamilies(primaryTablePath);
            this.indexedFieldList = this.buildIndexedFieldList(this.cfIdAttributesMap);
            this.fpIdxTofpMap = this.buildFpIdxTofpMap();
            this.missingAndNullFirst = this.indexInfo.getMissingAndNullOrdering() == Dbserver.SIndexInfo.MissingAndNullOrdering.MissingAndNullFirst;
            this.closed = false;
            this.initCommon(this.cfAttrs);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "<init>()");
        }
    }

    public MapRDBIndexImpl(Configuration config, IndexDesc indexDesc) throws DBException, TableNotFoundException {
        super(config);
        try {
            this.maprTable = new MapRHTable();
            this.tablePath = new Path(indexDesc.getPrimaryTablePath());
            this.siFid = indexDesc.getIndexFid();
            this.indexName = indexDesc.getIndexName();
            this.maprTable.init(config, this.tablePath, this.indexName, this.siFid);
            this.isHashed = indexDesc.isHashed();
            this.cfAttrs = this.maprTable.getMapRFS().listColumnFamily(this.tablePath, false, true);
            this.cfIdAttributesMap = this.getPrimaryTableFamilies(this.tablePath);
            this.indexedFieldList = indexDesc.getIndexedFields();
            this.includedFieldList = indexDesc.getIncludedFields();
            this.indexInfo = null;
            this.fpIdxTofpMap = this.buildFpIdxTofpMap(indexDesc);
            this.missingAndNullFirst = indexDesc.getMissingAndNullOrdering() == IndexDesc.MissingAndNullOrdering.MissingAndNullFirst;
            this.closed = false;
            this.initCommon(this.cfAttrs);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "<init>()");
        }
    }

    public Path getTablePath() {
        return this.tablePath;
    }

    private Map<Integer, Dbserver.ColumnFamilyAttr> getPrimaryTableFamilies(Path primaryTablePath) throws IOException {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Dbserver.ColumnFamilyAttr columnFamilyAttr : this.cfAttrs) {
            int cfId = columnFamilyAttr.getSchFamily().getId();
            builder.put((Object)cfId, (Object)columnFamilyAttr);
        }
        return builder.build();
    }

    private List<IndexFieldDesc> buildIndexedFieldList(Map<Integer, Dbserver.ColumnFamilyAttr> cfIdAttributesMap) throws IOException {
        ImmutableList.Builder fieldListBuilder = ImmutableList.builder();
        for (Dbserver.SIndexInfo.FieldInfo entry : this.indexInfo.getIndexedFieldsList()) {
            FieldPath fp = null;
            boolean isOnMTime = entry.hasUpdateTimestamp() && entry.getUpdateTimestamp();
            int fpIdx = 0;
            if (!isOnMTime) {
                String cfid = String.valueOf(entry.getFieldPathQualifier(0).getFamily());
                String qual = entry.getFieldPathQualifier(0).getQualifiers(0).toStringUtf8();
                fp = MapRDBTableImplHelper.cfQualifierToJsonPath(cfIdAttributesMap.get(Integer.parseInt(cfid)).getSchFamily().getName(), qual, this.cfAttrs);
                fpIdx = entry.getFieldPathIdx(0);
            }
            if (entry.getMapInfo().getType() != Dbserver.SIndexInfo.MappingType.NONE) {
                fieldListBuilder.add((Object)new IndexFieldDescImpl(fp, fpIdx, entry.getSortOrder(), true, isOnMTime));
                continue;
            }
            fieldListBuilder.add((Object)new IndexFieldDescImpl(fp, fpIdx, entry.getSortOrder(), false, isOnMTime));
        }
        return fieldListBuilder.build();
    }

    private Map<Integer, FieldPath> buildFpIdxTofpMap() throws IOException {
        String qual;
        String cfid;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        String fp = null;
        HashSet<Integer> fieldIdxSeen = new HashSet<Integer>();
        for (Dbserver.SIndexInfo.FieldInfo entry : this.indexInfo.getNonindexedFieldsList()) {
            if (fieldIdxSeen.contains(entry.getFieldPathIdx(0))) continue;
            fieldIdxSeen.add(entry.getFieldPathIdx(0));
            cfid = String.valueOf(entry.getFieldPathQualifier(0).getFamily());
            qual = entry.getFieldPathQualifier(0).getQualifiers(0).toStringUtf8();
            fp = MapRDBTableImplHelper.cfQualifierToJsonPath(this.cfIdAttributesMap.get(Integer.parseInt(cfid)).getSchFamily().getName(), qual, this.cfAttrs).toString();
            builder.put((Object)entry.getFieldPathIdx(0), (Object)FieldPath.parseFrom((String)fp));
        }
        for (Dbserver.SIndexInfo.FieldInfo entry : this.indexInfo.getIndexedFieldsList()) {
            if (entry.hasUpdateTimestamp() && entry.getUpdateTimestamp() || fieldIdxSeen.contains(entry.getFieldPathIdx(0))) continue;
            fieldIdxSeen.add(entry.getFieldPathIdx(0));
            cfid = String.valueOf(entry.getFieldPathQualifier(0).getFamily());
            qual = entry.getFieldPathQualifier(0).getQualifiers(0).toStringUtf8();
            fp = MapRDBTableImplHelper.cfQualifierToJsonPath(this.cfIdAttributesMap.get(Integer.parseInt(cfid)).getSchFamily().getName(), qual, this.cfAttrs).toString();
            builder.put((Object)entry.getFieldPathIdx(0), (Object)FieldPath.parseFrom((String)fp));
        }
        return builder.build();
    }

    private Map<Integer, FieldPath> buildFpIdxTofpMap(IndexDesc indexDesc) throws IOException {
        IndexFieldDescImpl entry;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        String fp = null;
        HashSet<Integer> fieldIdxSeen = new HashSet<Integer>();
        for (IndexFieldDesc fieldDesc : indexDesc.getIncludedFields()) {
            entry = (IndexFieldDescImpl)fieldDesc;
            if (fieldIdxSeen.contains(entry.getFieldPathIdx())) continue;
            fieldIdxSeen.add(entry.getFieldPathIdx());
            fp = entry.getFieldPathStr();
            builder.put((Object)entry.getFieldPathIdx(), (Object)FieldPath.parseFrom((String)fp));
        }
        for (IndexFieldDesc fieldDesc : indexDesc.getIndexedFields()) {
            entry = (IndexFieldDescImpl)fieldDesc;
            if (entry.isOnMTime() || fieldIdxSeen.contains(entry.getFieldPathIdx())) continue;
            fieldIdxSeen.add(entry.getFieldPathIdx());
            fp = entry.getFieldPathStr();
            builder.put((Object)entry.getFieldPathIdx(), (Object)FieldPath.parseFrom((String)fp));
        }
        return builder.build();
    }

    private Dbserver.SIndexInfo getIndexInfo(Path priTablePath, String indexFidStr, String indexName) throws IOException {
        Dbserver.TableReplicaListResponse resp = this.maprTable.getMapRFS().listTableIndexes(priTablePath, false, false, true);
        for (Dbserver.TableReplicaDesc rd : resp.getReplicasList()) {
            Dbserver.SIndexInfo siInfo = rd.getSiInfo();
            String fidStr = Fids.fidToString((Common.FidMsg)siInfo.getIndexFid());
            if (!indexFidStr.equalsIgnoreCase(fidStr)) continue;
            return siInfo;
        }
        throw new IOException(String.format("Unable to find index information for table %s, index %s(%s)", priTablePath, indexName, indexFidStr));
    }

    public String fieldPathToIdQual(String fieldPath) {
        if (this.indexInfo != null) {
            for (Dbserver.SIndexInfo.FieldInfo component : this.indexInfo.getNonindexedFieldsList()) {
                String cfid = String.valueOf(component.getFieldPathQualifier(0).getFamily());
                String qual = component.getFieldPathQualifier(0).getQualifiers(0).toStringUtf8();
                String fp = MapRDBTableImplHelper.cfQualifierToJsonPath(this.cfIdAttributesMap.get(Integer.parseInt(cfid)).getSchFamily().getName(), qual, this.cfAttrs).toString();
                if (fieldPath.equals(fp)) {
                    return String.valueOf(component.getFieldPathIdx(0));
                }
                if (fieldPath.length() <= fp.length() + 1 || !fieldPath.startsWith(fp) || fieldPath.charAt(fp.length()) != '.' && fieldPath.charAt(fp.length()) != '[') continue;
                return component.getFieldPathIdx(0) + fieldPath.substring(fp.length());
            }
        } else {
            for (IndexFieldDesc component : this.includedFieldList) {
                IndexFieldDescImpl fieldDesc = (IndexFieldDescImpl)component;
                String fp = fieldDesc.getFieldPathStr();
                int fpIdx = fieldDesc.getFieldPathIdx();
                if (fieldPath.equals(fp)) {
                    return String.valueOf(fpIdx);
                }
                if (fieldPath.length() <= fp.length() + 1 || !fieldPath.startsWith(fp) || fieldPath.charAt(fp.length()) != '.' && fieldPath.charAt(fp.length()) != '[') continue;
                return fpIdx + fieldPath.substring(fp.length());
            }
        }
        return null;
    }

    public int getIndexRowkeyPos(String fieldPath) {
        int pos = 0;
        boolean indexOnSystemField = fieldPath.startsWith("$$");
        if (indexOnSystemField) {
            return -1;
        }
        if (fieldPath.startsWith("$")) {
            return Integer.parseInt(fieldPath.substring(1));
        }
        for (IndexFieldDesc component : this.indexedFieldList) {
            String fp = component.getFieldPath().asPathString();
            if (fieldPath.equals(fp)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public String getNonIndexedComponentPath(String fieldpath) throws IOException {
        if (this.indexInfo != null) {
            for (Dbserver.SIndexInfo.FieldInfo component : this.indexInfo.getNonindexedFieldsList()) {
                String cfid = String.valueOf(component.getFieldPathQualifier(0).getFamily());
                String qual = component.getFieldPathQualifier(0).getQualifiers(0).toStringUtf8();
                String fp = MapRDBTableImplHelper.cfQualifierToJsonPath(this.cfIdAttributesMap.get(Integer.parseInt(cfid)).getSchFamily().getName(), qual, this.cfAttrs).toString();
                if (fieldpath.equals(fp)) {
                    return String.valueOf(component.getFieldPathIdx(0));
                }
                if (fieldpath.length() <= fp.length() + 1 || !fieldpath.startsWith(fp) || fieldpath.charAt(fp.length()) != '.' && fieldpath.charAt(fp.length()) != '[') continue;
                return component.getFieldPathIdx(0) + fieldpath.substring(fp.length());
            }
        } else {
            for (IndexFieldDesc component : this.includedFieldList) {
                IndexFieldDescImpl fieldDesc = (IndexFieldDescImpl)component;
                String fp = fieldDesc.getFieldPathStr();
                int fpIdx = fieldDesc.getFieldPathIdx();
                if (fieldpath.equals(fp)) {
                    return String.valueOf(fpIdx);
                }
                if (fieldpath.length() <= fp.length() + 1 || !fieldpath.startsWith(fp) || fieldpath.charAt(fp.length()) != '.' && fieldpath.charAt(fp.length()) != '[') continue;
                return fpIdx + fieldpath.substring(fp.length());
            }
        }
        throw new IOException(String.format("Unable to find corresponding nonindexed field", new Object[0]));
    }

    public IndexFieldDesc.Order getIndexComponentOrder(String fieldPath) throws IOException {
        boolean indexOnUpdateTS = "$$timestamp".equals(fieldPath);
        if (!indexOnUpdateTS && fieldPath.startsWith("$")) {
            return this.indexedFieldList.get(Integer.parseInt(fieldPath.substring(1))).getSortOrder();
        }
        for (IndexFieldDesc component : this.indexedFieldList) {
            String fp;
            if (!(component.isOnMTime() ? indexOnUpdateTS : (fp = ((IndexFieldDescImpl)component).getFieldPathStr()).equals(fieldPath))) continue;
            return component.getSortOrder();
        }
        throw new IOException(String.format("Unable to find index component order", new Object[0]));
    }

    @Override
    public Document findById(String id, FieldPath ... fields) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(String id, String ... paths) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(ByteBuffer id, FieldPath ... fields) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(ByteBuffer id, String ... paths) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(Value id, FieldPath ... fields) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(Value id, String ... paths) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(String id, QueryCondition c) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(Value id, QueryCondition c) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(String id, QueryCondition c, FieldPath ... fields) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(String id, QueryCondition c, String ... paths) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c, FieldPath ... fields) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(ByteBuffer id, QueryCondition c, String ... paths) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(Value id, QueryCondition c, String ... paths) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public Document findById(Value id, QueryCondition c, FieldPath ... fields) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, String id) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, String id, FieldPath ... fields) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, String id, String ... paths) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, FieldPath ... fields) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, String ... paths) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c, FieldPath ... fields) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c, String ... paths) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c, FieldPath ... fields) {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c, String ... paths) {
        throw this.tableOperationNotSupported();
    }

    @Override
    protected DocumentStream _doScan(QueryCondition condition, String ... paths) throws DBException {
        MapRDBTableImplHelper.CondAndProjPaths bothpaths = new MapRDBTableImplHelper.CondAndProjPaths();
        MapRDBTableImplHelper.setPaths(condition, paths, bothpaths);
        ArrayList<String> pathList = null;
        if (paths != null) {
            pathList = new ArrayList<String>(Arrays.asList(paths));
            if (bothpaths.condPaths != null) {
                for (FieldPath fp : bothpaths.condPaths) {
                    if (pathList.contains(fp.toString()) || this.getIndexRowkeyPos(fp.toString()) != -1) continue;
                    pathList.add(fp.toString());
                }
            }
        }
        String[] pathArray = paths == null ? null : pathList.toArray(new String[pathList.size()]);
        MapRScan maprscan = MapRDBTableImplHelper.toMapRScan((BaseJsonTable)this, condition, true, true, pathArray);
        try {
            long id = this.maprTable.getInode().getScanner(maprscan);
            MapRResultScanner scanner = new MapRResultScanner(maprscan, this.maprTable, id);
            this.maprTable.addScanner(scanner);
            if (paths != null) {
                return new DBDocumentStream(scanner, this.isExcludeId(), this, bothpaths.condPaths, paths);
            }
            return new DBDocumentStream(scanner, this.isExcludeId(), this);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "index scan()");
        }
    }

    public DocumentStream _doErrorScan() throws DBException {
        MapRScan maprscan = MapRDBTableImplHelper.toMapRScan((BaseJsonTable)this, null, false, true, (String[])null);
        ConditionNode.RowkeyRange rkr = IndexRowKeyEncoder.getErrRowKeyRange(this.isHashed);
        maprscan.startRow = rkr.getStartRow();
        maprscan.stopRow = rkr.getStopRow();
        try {
            long id = this.maprTable.getInode().getScanner(maprscan);
            MapRResultScanner scanner = new MapRResultScanner(maprscan, this.maprTable, id);
            this.maprTable.addScanner(scanner);
            return new DBDocumentStream(scanner, this.isExcludeId(), this);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "index error scan()");
        }
    }

    @Override
    protected ConditionImpl _cloneCondition(QueryCondition condition) {
        return ((ConditionImpl)condition).cloneUnbuilt().setPartitionKeys(this.indexedFieldList, false, 0, this.missingAndNullFirst).build();
    }

    @Override
    protected ConditionImpl _cloneConditionOptimized(QueryCondition condition) {
        return ((ConditionImpl)condition).cloneUnbuilt().setPartitionKeys(this.indexedFieldList, false, 0, this.missingAndNullFirst).build(true);
    }

    @Override
    public void insertOrReplace(Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insertOrReplace(String id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insertOrReplace(ByteBuffer id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void insertOrReplace(Value id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insertOrReplace(Document r, FieldPath fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insertOrReplace(Document r, String fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insertOrReplace(DocumentStream rs) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insertOrReplace(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insertOrReplace(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void update(String id, DocumentMutation m) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void update(ByteBuffer id, DocumentMutation m) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void update(Value id, DocumentMutation m) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(String id) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(ByteBuffer id) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void delete(Value id) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(Document r, FieldPath fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(Document r, String fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(DocumentStream rs) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void delete(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(String id, String field, long inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(ByteBuffer id, String field, long inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void increment(Value id, String field, long inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(String id, String field, float inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(ByteBuffer id, String field, float inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void increment(Value id, String field, float inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(String id, String field, double inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(ByteBuffer id, String field, double inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void increment(Value id, String field, double inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(String id, String field, BigDecimal inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(ByteBuffer id, String field, BigDecimal inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void increment(Value id, String field, BigDecimal inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(String id, String field, byte inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(ByteBuffer id, String field, byte inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void increment(Value id, String field, byte inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(String id, String field, short inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(ByteBuffer id, String field, short inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void increment(Value id, String field, short inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(String id, String field, int inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void increment(ByteBuffer id, String field, int inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void increment(Value id, String field, int inc) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(String id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(ByteBuffer id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void insert(Value id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(Document r, FieldPath fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(Document r, String fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(DocumentStream rs) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void insert(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(String id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(ByteBuffer id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public void replace(Value id, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(Document r, FieldPath fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(Document r, String fieldAsKey) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(DocumentStream rs) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public void replace(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public boolean checkAndMutate(String id, QueryCondition condition, DocumentMutation m) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public boolean checkAndMutate(ByteBuffer id, QueryCondition condition, DocumentMutation m) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public boolean checkAndMutate(Value id, QueryCondition condition, DocumentMutation m) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public boolean checkAndDelete(String id, QueryCondition condition) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public boolean checkAndDelete(ByteBuffer id, QueryCondition condition) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public boolean checkAndDelete(Value id, QueryCondition condition) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public boolean checkAndReplace(String id, QueryCondition condition, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public boolean checkAndReplace(ByteBuffer id, QueryCondition condition, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    public boolean checkAndReplace(Value id, QueryCondition condition, Document r) throws DBException {
        throw this.tableOperationNotSupported();
    }

    @Override
    public synchronized void _doClose() throws DBException {
    }

    @Override
    public List<ConditionNode.RowkeyRange> getRowkeyRanges(QueryCondition condition) {
        ConditionImpl condImpl = this._cloneCondition(condition);
        return condImpl.getRowkeyRanges();
    }

    protected TabletInfo[] _getTabletInfos(QueryCondition condition) throws IOException {
        return this._getTabletInfos(condition, false, false);
    }

    @Override
    protected TabletInfo[] _getTabletInfos(QueryCondition condition, boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        if (condition == null) {
            return this.getTabletInfos(needSpaceUsage, prefetchTabletMap);
        }
        ConditionImpl condImpl = this._cloneCondition(condition);
        List<ConditionNode.RowkeyRange> rowkeys = condImpl.getRowkeyRanges();
        if (ConditionNode.RowkeyRange.isCoversEntireRange(rowkeys)) {
            return this.getTabletInfos(needSpaceUsage, prefetchTabletMap);
        }
        ArrayList tabletInfos = Lists.newArrayList();
        for (int i = 0; i < rowkeys.size(); ++i) {
            List nextTabletSet;
            ConditionNode.RowkeyRange rr = rowkeys.get(i);
            byte[] startRow = rr.getStartRow();
            byte[] endRow = rr.getStopRow();
            boolean doneScanningTablets = false;
            MapRTabletScanner scanner = this.maprTable.getTabletScanner(startRow, endRow, needSpaceUsage, prefetchTabletMap);
            while ((nextTabletSet = scanner.nextSet()) != null) {
                for (Dbserver.TabletDesc tablet : nextTabletSet) {
                    byte[] srow = tablet.getStartKey().toByteArray();
                    byte[] erow = tablet.getEndKey().toByteArray();
                    if (srow == null || erow == null) {
                        throw new DBException("Missing start and/or endkey in tablet");
                    }
                    int leftRangeComp = startRow != null && startRow.length != 0 ? (erow.length == 0 ? -1 : Bytes.compareTo((byte[])startRow, (byte[])erow)) : -1;
                    int rightRangeComp = endRow != null && endRow.length != 0 ? (srow.length == 0 ? 1 : Bytes.compareTo((byte[])endRow, (byte[])srow)) : 1;
                    if (leftRangeComp < 0 && rightRangeComp < 0) {
                        doneScanningTablets = true;
                        break;
                    }
                    if (startRow == endRow) {
                        if (leftRangeComp >= 0 || rightRangeComp < 0) continue;
                        tabletInfos.add(this.toTabletInfo(tablet, rr));
                        continue;
                    }
                    if (leftRangeComp >= 0 || rightRangeComp <= 0) continue;
                    tabletInfos.add(this.toTabletInfo(tablet, rr));
                }
                if (!doneScanningTablets) continue;
            }
        }
        return tabletInfos.toArray(new TabletInfo[tabletInfos.size()]);
    }

    protected TabletInfo toTabletInfo(Dbserver.TabletDesc tablet, ConditionNode.RowkeyRange rr) throws IOException {
        byte[] end;
        byte[] start;
        int cid = tablet.getFid().getCid();
        String host = this.maprTable.getServerForCid(cid);
        String[] tokens = host.split(":");
        if (tokens == null || tokens.length != 2) {
            throw new IOException("Bad host information for cid=" + cid + ", host=" + host);
        }
        long estimatedSize = 0L;
        long estimatedNumRows = 0L;
        if (tablet.hasSpaceUsage()) {
            estimatedNumRows = tablet.getSpaceUsage().getNumRows();
            estimatedSize = tablet.getSpaceUsage().getNumLogicalBlocks() * 8192L;
        }
        if (rr != null) {
            start = Bytes.maxOfStartRows((byte[])tablet.getStartKey().toByteArray(), (byte[])rr.getStartRow());
            end = Bytes.minOfStopRows((byte[])tablet.getEndKey().toByteArray(), (byte[])rr.getStopRow());
        } else {
            start = tablet.getStartKey().toByteArray();
            end = tablet.getEndKey().toByteArray();
        }
        ConditionImpl c = this.getRangeCondition(start, end);
        return new TabletInfoImpl(c, new ConditionNode.RowkeyRange(start, end), new String[]{tokens[0]}, estimatedSize, estimatedNumRows, tablet.getFid());
    }

    private UnsupportedOperationException tableOperationNotSupported() {
        return new UnsupportedOperationException("Requested operation is not supported on Index Table");
    }

    public Logger getLogger() {
        return logger;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    public BaseJsonTable.TableType getTableType() {
        return BaseJsonTable.TableType.TABLE_INDEX;
    }

    @Override
    public List<IndexFieldDesc> getIndexedFieldList() {
        return this.indexedFieldList;
    }

    public Map<Integer, FieldPath> getFpIdxTofpMap() {
        return this.fpIdxTofpMap;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    public boolean isHashed() {
        return this.isHashed;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String asJsonString() {
        if (this.jsonString == null) {
            try {
                JSONArray jsaIndex = new JSONArray();
                for (IndexFieldDesc indexFieldDesc : this.indexedFieldList) {
                    jsaIndex.put((Object)indexFieldDesc.toString());
                }
                JSONArray jsaInclude = new JSONArray();
                for (IndexFieldDesc field : this.includedFieldList) {
                    jsaInclude.put((Object)field.toString());
                }
                JSONStringer jSONStringer = new JSONStringer().object().key("tablePath").value((Object)this.tablePath).key("indexName").value((Object)this.indexName).key("indexFID").value((Object)this.siFid).key("isHashed").value(this.isHashed).key("missingAndNullFirst").value(this.missingAndNullFirst).key("indexedFieldList").value((Object)jsaIndex).key("includedFieldList").value((Object)jsaInclude).endObject();
                this.jsonString = jSONStringer.toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this.jsonString;
    }

    public String asJsonString(JsonOptions arg0) {
        return this.asJsonString();
    }

    public static int CompareKeys(ByteBuffer key1, ByteBuffer key2) {
        return MapRDBIndexImpl.CompareKeys(key1.array(), key2.array());
    }

    public static int CompareKeys(byte[] key1, byte[] key2) {
        return Bytes.compareTo((byte[])key1, (byte[])key2);
    }
}

