/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.AdminProvider;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.FamilyDescriptorImpl;
import com.mapr.db.impl.MapRDBHashedIndexImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.ojai.DBDocumentBuilder;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.MutationImpl;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.beans.BeanCodec;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.Json;
import org.ojai.store.DocumentMutation;
import org.ojai.util.Documents;

@API.Internal
public class MapRDBImpl {
    private static final Configuration DEFAULT_CONFIGURATION = new Configuration();
    private static final AdminProvider adminProvider = new AdminProvider();

    public static boolean tableExists(String tablePath) throws DBException {
        try (Admin admin = MapRDBImpl.newAdmin();){
            boolean bl = admin.tableExists(tablePath);
            return bl;
        }
    }

    public static Table createTable(String tablePath) throws DBException {
        try (Admin admin = MapRDBImpl.newAdmin();){
            Table table = admin.createTable(MapRDBImpl.newTableDescriptor(tablePath));
            return table;
        }
    }

    public static boolean deleteTable(String tablePath) throws DBException {
        try (Admin admin = MapRDBImpl.newAdmin();){
            boolean bl = admin.deleteTable(tablePath);
            return bl;
        }
    }

    public static Table getTable(String pathName) throws DBException {
        return MapRDBImpl.getTable(new Path(pathName));
    }

    public static Table getTable(Path path) throws DBException {
        return new MapRDBTableImpl(DEFAULT_CONFIGURATION, path);
    }

    public static Table getTable(Configuration conf, Path path) throws DBException {
        return new MapRDBTableImpl(conf, path);
    }

    public static Table getIndexTable(IndexDesc indexDesc) throws DBException {
        if (indexDesc == null) {
            throw new DBException("Invalid input parameters.");
        }
        if (indexDesc.isHashed()) {
            return new MapRDBHashedIndexImpl(DEFAULT_CONFIGURATION, indexDesc);
        }
        return new MapRDBIndexImpl(DEFAULT_CONFIGURATION, indexDesc);
    }

    public static Table getIndexTable(Path primaryTablePath, String indexFid, String indexName) throws DBException {
        AdminImpl admin = (AdminImpl)MapRDBImpl.newAdmin();
        Collection<IndexDesc> indexes = admin.getTableIndexes(primaryTablePath);
        IndexDesc found = null;
        for (IndexDesc index : indexes) {
            if (!index.getIndexFid().equals(indexFid)) continue;
            found = index;
            break;
        }
        return MapRDBImpl.getIndexTable(found);
    }

    public static Admin getAdmin(Configuration conf) {
        return adminProvider.getAdmin(conf);
    }

    public static Admin newAdmin() throws DBException {
        return new AdminImpl(DEFAULT_CONFIGURATION);
    }

    public static Admin newAdmin(Configuration c) throws DBException {
        return new AdminImpl(c);
    }

    public static TableDescriptor newTableDescriptor() {
        return new TableDescriptorImpl();
    }

    public static TableDescriptor newTableDescriptor(String tablePath) {
        return new TableDescriptorImpl(new Path(tablePath));
    }

    public static TableDescriptor newTableDescriptor(Path tablePath) {
        return new TableDescriptorImpl(tablePath);
    }

    public static FamilyDescriptor newFamilyDescriptor() {
        return new FamilyDescriptorImpl();
    }

    public static FamilyDescriptor newDefaultFamilyDescriptor() {
        return new FamilyDescriptorImpl("default", FieldPath.EMPTY);
    }

    public static FamilyDescriptor newFamilyDescriptor(String familyName, String jsonPath) {
        return new FamilyDescriptorImpl(familyName, jsonPath);
    }

    public static FamilyDescriptor newFamilyDescriptor(String familyName, FieldPath jsonPath) {
        return new FamilyDescriptorImpl(familyName, jsonPath);
    }

    public static Document newDocument() {
        return new DBDocumentImpl();
    }

    public static Document newDocument(String jsonString) throws DecodingException {
        DocumentReader reader = Json.newDocumentReader((String)jsonString);
        DBDocumentBuilder writer = new DBDocumentBuilder();
        Documents.writeReaderToBuilder((DocumentReader)reader, (DocumentBuilder)writer);
        return writer.getDocument();
    }

    public static Document newDocument(Map<String, Object> map) throws DecodingException {
        return (Document)DBValueBuilderImpl.KeyValueBuilder.initFrom(map);
    }

    public static Document newDocument(Object bean) throws DecodingException {
        return BeanCodec.decode((DocumentBuilder)MapRDBImpl.newDocumentBuilder(), (Object)bean);
    }

    public static DocumentBuilder newDocumentBuilder() {
        return new DBDocumentBuilder();
    }

    public static DocumentMutation newMutation() {
        return new MutationImpl();
    }

    public static ConditionImpl newCondition() {
        return new ConditionImpl();
    }

    private MapRDBImpl() {
    }
}

