/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.utils.JsonUtils;
import com.mapr.utils.Regexes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.QueryCondition;
import org.ojai.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
class ConditionLeaf
extends ConditionNode {
    static Logger logger = LoggerFactory.getLogger(ConditionLeaf.class);
    final FieldPath field;
    final String fieldStr;
    final Dbfilters.CompareOpProto op;
    final Dbfilters.ComparatorModeProto cmpMode;
    final KeyValue value;
    MapRDBIndexImpl indexTable = null;
    boolean nonindexed = false;
    private static final BiMap<Dbfilters.CompareOpProto, QueryCondition.Op> opProtoMapInverse = opProtoMap.inverse();
    private static final BaseEncoding base64UrlEncoder = BaseEncoding.base64Url();

    ConditionLeaf(FieldPath path, QueryCondition.Op op, KeyValue initFrom, QueryCondition c) {
        this(path, (Dbfilters.CompareOpProto)opProtoMap.get((Object)op), initFrom, c);
    }

    ConditionLeaf(FieldPath field, Dbfilters.CompareOpProto op, KeyValue value, QueryCondition c) {
        this(field, op, value, Dbfilters.ComparatorModeProto.CMP_VALUE, c);
    }

    ConditionLeaf(FieldPath field, QueryCondition.Op op, KeyValue value, Dbfilters.ComparatorModeProto cmpMode, QueryCondition c) {
        this(field, (Dbfilters.CompareOpProto)opProtoMap.get((Object)op), value, cmpMode, c);
    }

    ConditionLeaf(FieldPath field, Dbfilters.CompareOpProto op, KeyValue value, Dbfilters.ComparatorModeProto cmpMode, QueryCondition c) {
        super(c);
        this.op = op;
        this.field = field;
        this.value = value;
        this.cmpMode = cmpMode;
        this.fieldStr = field.asPathString();
        this.checkArgs();
    }

    ConditionLeaf(String filterId, ByteString serializedState, QueryCondition c) {
        super(c);
        Dbfilters.FilterComparatorProto filterComparator = null;
        try {
            switch (filterId) {
                case "8cbdcd12": {
                    Dbfilters.ConditionFilterProto proto = Dbfilters.ConditionFilterProto.parseFrom((ByteString)serializedState);
                    this.field = FieldPath.parseFrom((String)proto.getFieldPath());
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                case "469dbd04": {
                    this.field = DocumentConstants.ID_FIELD;
                    Dbfilters.ConditionFilterProto proto = Dbfilters.RowFilterProto.parseFrom((ByteString)serializedState);
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                case "rk_filter": {
                    this.field = Constants.ROWKEY_FIELD_PATH;
                    Dbfilters.ConditionFilterProto proto = Dbfilters.RowFilterProto.parseFrom((ByteString)serializedState);
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid filter id: " + filterId);
                }
            }
            this.op = filterComparator.getCompareOp();
            if (filterComparator.hasComparator() && filterComparator.getComparator().hasSerializedComparator()) {
                String name = filterComparator.getComparator().getName();
                ByteString state = filterComparator.getComparator().getSerializedComparator();
                switch (name) {
                    case "45a94888": {
                        Dbfilters.BinaryComparatorProto binaryComparator = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state);
                        ByteBuffer encoded = binaryComparator.getComparable().asReadOnlyByteBuffer();
                        encoded.order(ByteOrder.LITTLE_ENDIAN);
                        HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
                        bufferMap.put(0, encoded);
                        DBDocumentImpl doc = RowcolCodec.decode(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP);
                        this.value = (KeyValue)doc.getValue(Dbfilters.ConditionLeafFieldsProto.getDefaultInstance().getXField());
                        break;
                    }
                    case "e2d7ba40": {
                        Dbfilters.RegexStringComparatorProto regexComparator = Dbfilters.RegexStringComparatorProto.parseFrom((ByteString)state);
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFrom(regexComparator.getPattern().toStringUtf8());
                        break;
                    }
                    case "05f39865": {
                        ByteString byteString = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state).getComparable();
                        this.value = IdCodec.decode(byteString.asReadOnlyByteBuffer());
                        break;
                    }
                    case "2e7025c4": {
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFrom(Dbfilters.SizeComparatorProto.parseFrom((ByteString)state).getSize());
                        break;
                    }
                    case "8543f5eb": {
                        this.value = null;
                        break;
                    }
                    case "1e95fd6b": {
                        this.value = DBValueBuilderImpl.KeyValueBuilder.initFrom(Dbfilters.TypeComparatorProto.parseFrom((ByteString)state).getType());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid comparator id: " + name);
                    }
                }
            } else {
                this.value = null;
            }
            this.cmpMode = filterComparator.hasComparatorMode() ? filterComparator.getComparatorMode() : null;
            this.fieldStr = this.field.asPathString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode message", e);
        }
        this.checkArgs();
    }

    Dbfilters.CompareOpProto getOp() {
        return this.op;
    }

    FieldPath getField() {
        return this.field;
    }

    @Override
    boolean checkAndPrune() {
        return (this.isOnRowKey() || this.isOnPartitionKeyPrefix()) && this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE && this.op != Dbfilters.CompareOpProto.NOT_EQUAL && opProtoMap.containsValue((Object)this.op) && this.value != null;
    }

    @Override
    void addProjections(Set<FieldPath> proj) {
        proj.add(this.field);
    }

    @Override
    StringBuilder expressionBuilder(StringBuilder sb) {
        return this.treeBuilder(sb, 0);
    }

    public String toString() {
        return this.expressionBuilder(new StringBuilder()).toString();
    }

    @Override
    StringBuilder treeBuilder(StringBuilder sb, int level) {
        return sb.append('(').append(this.getFieldStr(sb)).append(' ').append(this.getOpStr(sb)).append(' ').append(this.getValueStr(sb)).append(')');
    }

    private String getFieldStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_PATTERN: 
            case CMP_VALUE: {
                sb.append(this.field.asPathString());
                break;
            }
            case CMP_TYPE: {
                sb.append("TYPE_OF(").append(this.fieldStr).append(')');
                break;
            }
            case CMP_SIZE: {
                sb.append("SIZE_OF(").append(this.fieldStr).append(')');
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return "";
    }

    private String getValueStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_PATTERN: 
            case CMP_VALUE: 
            case CMP_SIZE: {
                if (this.value == null) {
                    sb.append("null");
                    break;
                }
                if (this.value.getType() == Value.Type.BINARY) {
                    sb.append("{\"").append("$binary").append("\":").append(JsonUtils.toJsonValue((ByteBuffer)this.value.getBinary())).append('}');
                    break;
                }
                sb.append(Values.asJsonString((Value)this.value));
                break;
            }
            case CMP_TYPE: {
                sb.append(Value.Type.valueOf((int)this.value.getInt()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return "";
    }

    private String getOpStr(StringBuilder sb) {
        switch (this.cmpMode) {
            case CMP_VALUE: 
            case CMP_TYPE: 
            case CMP_SIZE: {
                sb.append((String)opSymbolMap.get(this.op));
                break;
            }
            case CMP_PATTERN: {
                sb.append(this.op == Dbfilters.CompareOpProto.EQUAL ? "MATCHES" : "NOT_MATCHES");
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
            }
        }
        return "";
    }

    @Override
    StringBuilder jsonBuilder(StringBuilder sb) {
        return sb.append('{').append('\"').append(this.fieldStr).append('\"').append(':').append(' ').append('{').append('\"').append(((String)opJsonOpMap.get(this.op)).toLowerCase()).append('\"').append(':').append(' ').append('}').append('}');
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
        return this.getDescriptor(pathIdMap, null);
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap, MapRDBIndexImpl indexTable) {
        if (this.isOnRowKey()) {
            return this.toRowKeyFilter(pathIdMap);
        }
        if (indexTable != null) {
            this.indexTable = indexTable;
            this.setSiIndex(true);
            return this.toIndexFilter(pathIdMap, indexTable);
        }
        if (this.isOnId()) {
            return this.toIdFieldFilter(pathIdMap);
        }
        return this.toConditionFilter(pathIdMap);
    }

    boolean isOnId() {
        return this.field.getRootSegment().isLastPath() && "_id".equals(this.field.getRootSegment().getNameSegment().getName());
    }

    boolean isOnRowKey() {
        return this.field.getRootSegment().isLastPath() && "$$row_key".equals(this.field.getRootSegment().getNameSegment().getName());
    }

    private void checkArgs() {
        if (this.cmpMode == null) {
            throw new IllegalArgumentException("ComparatorModeProto can not be null.");
        }
        if (this.op == null) {
            throw new IllegalArgumentException("CompareOpProto can not be null.");
        }
        if (this.field == null) {
            throw new IllegalArgumentException("FieldPath can not be null.");
        }
        if (this.isOnPartitionKeyPrefix() && (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE || this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) && this.value != null && !IdCodec.isSupportedType(this.value.getType())) {
            throw new IllegalArgumentException(String.format("A %s value can not be used for '_id' field.", this.value.getType()));
        }
        if (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
            Pattern.compile(this.value.getString());
        }
    }

    private ConditionDescriptor toRowKeyFilter(BiMap<FieldPath, Integer> pathIdMap) {
        Dbfilters.RowFilterProto rowFilter = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(this.getComparator(true)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("rk_filter").setSerializedState(rowFilter.toByteString()).build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry pathIdEntry : pathIdMap.inverse().entrySet()) {
            mapBuilder.put(pathIdEntry.getKey(), (Object)ImmutableSet.of(pathIdEntry.getValue()));
        }
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)mapBuilder.build());
    }

    private ConditionDescriptor toIdFieldFilter(BiMap<FieldPath, Integer> pathIdMap) {
        Dbfilters.RowFilterProto rowFilter = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(this.getComparator(true)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("469dbd04").setSerializedState(rowFilter.toByteString()).build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry pathIdEntry : pathIdMap.inverse().entrySet()) {
            mapBuilder.put(pathIdEntry.getKey(), (Object)ImmutableSet.of(pathIdEntry.getValue()));
        }
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)mapBuilder.build());
    }

    private ConditionDescriptor toIndexFilter(BiMap<FieldPath, Integer> pathIdMap, MapRDBIndexImpl indexTable) {
        int indexPos;
        Dbfilters.FilterMsg filterMsg = null;
        int n = indexPos = this.isOnId() ? 0 : indexTable.getIndexRowkeyPos(this.fieldStr);
        if (indexPos != -1) {
            Dbfilters.IndexRowKeyFilterProto indexFilter = Dbfilters.IndexRowKeyFilterProto.newBuilder().setOnIdField(this.isOnId()).setRowKeyPosition(indexPos).setFilterComparator(this.getComparator(this.isOnId())).build();
            filterMsg = Dbfilters.FilterMsg.newBuilder().setId("17544506").setSerializedState(indexFilter.toByteString()).build();
        } else {
            this.nonindexed = true;
            String nonindexedfp = null;
            try {
                nonindexedfp = indexTable.getNonIndexedComponentPath(this.fieldStr);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("index field provided does not exist", e);
            }
            Dbfilters.ConditionFilterProto conditionFilter = Dbfilters.ConditionFilterProto.newBuilder().setFieldPath(nonindexedfp).setFamilyId(1).setFilterComparator(this.getComparator(false)).build();
            filterMsg = Dbfilters.FilterMsg.newBuilder().setId("8cbdcd12").setSerializedState(conditionFilter.toByteString()).build();
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry pathIdEntry : pathIdMap.inverse().entrySet()) {
            mapBuilder.put(pathIdEntry.getKey(), (Object)ImmutableSet.of(pathIdEntry.getValue()));
        }
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)mapBuilder.build());
    }

    private ConditionDescriptor toConditionFilter(BiMap<FieldPath, Integer> pathIdMap) {
        FieldPath fieldPath = this.field;
        Integer familyId = (Integer)pathIdMap.get((Object)FieldPath.EMPTY);
        if (familyId == null) {
            throw new IllegalStateException("Unable to find family id for the default column family.");
        }
        FieldPath lastParent = null;
        for (Map.Entry kv : pathIdMap.entrySet()) {
            FieldSegment progeny;
            FieldPath familyPath = (FieldPath)kv.getKey();
            if (familyPath.equals((Object)FieldPath.EMPTY) || (progeny = this.field.segmentAfterAncestor(familyPath)) == null || lastParent != null && !lastParent.isAtOrAbove(familyPath)) continue;
            lastParent = familyPath;
            fieldPath = progeny.equals((Object)FieldPath.EMPTY.getRootSegment()) ? Constants.DUMMY_FIELDPATH_V : Constants.DUMMY_FIELDPATH_V.cloneWithNewChild(progeny);
            familyId = (Integer)kv.getValue();
        }
        Dbfilters.ConditionFilterProto conditionFilter = Dbfilters.ConditionFilterProto.newBuilder().setFieldPath(fieldPath.asPathString(false)).setFamilyId(familyId.intValue()).setFilterComparator(this.getComparator(false)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("8cbdcd12").setSerializedState(conditionFilter.toByteString()).build();
        return new ConditionDescriptor(filterMsg, (Map<Integer, ? extends Set<FieldPath>>)ImmutableMap.of((Object)familyId, (Object)ImmutableSet.of((Object)fieldPath)));
    }

    private Dbfilters.FilterComparatorProto getComparator(boolean onId) {
        if (this.indexTable != null && !this.nonindexed && this.cmpMode == Dbfilters.ComparatorModeProto.CMP_VALUE) {
            boolean asc = false;
            Dbfilters.CompareOpProto op = this.op;
            try {
                asc = "_id".equals(this.fieldStr) || IndexFieldDesc.Order.Asc == this.indexTable.getIndexComponentOrder(this.fieldStr);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to find component order", e);
            }
            if (!asc) {
                if (this.op.equals((Object)Dbfilters.CompareOpProto.GREATER)) {
                    op = Dbfilters.CompareOpProto.LESS;
                }
                if (this.op.equals((Object)Dbfilters.CompareOpProto.LESS)) {
                    op = Dbfilters.CompareOpProto.GREATER;
                }
                if (this.op.equals((Object)Dbfilters.CompareOpProto.GREATER_OR_EQUAL)) {
                    op = Dbfilters.CompareOpProto.LESS_OR_EQUAL;
                }
                if (this.op.equals((Object)Dbfilters.CompareOpProto.LESS_OR_EQUAL)) {
                    op = Dbfilters.CompareOpProto.GREATER_OR_EQUAL;
                }
            }
            Dbfilters.FilterComparatorProto.Builder filterComparator = Dbfilters.FilterComparatorProto.newBuilder().setComparatorMode(this.cmpMode).setCompareOp(op);
            filterComparator.setComparator(this.toComparator(onId));
            return filterComparator.build();
        }
        Dbfilters.FilterComparatorProto.Builder filterComparator = Dbfilters.FilterComparatorProto.newBuilder().setComparatorMode(this.cmpMode).setCompareOp(this.op);
        filterComparator.setComparator(this.toComparator(onId));
        return filterComparator.build();
    }

    private Dbfilters.ComparatorProto toComparator(boolean onId) {
        Dbfilters.ComparatorProto.Builder builder = Dbfilters.ComparatorProto.newBuilder();
        switch (this.cmpMode) {
            case CMP_VALUE: {
                return this.buildValueComparator(builder, onId);
            }
            case CMP_TYPE: {
                return this.buildTypeComparator(builder, onId);
            }
            case CMP_PATTERN: {
                return this.buildPatternComparator(builder, onId);
            }
            case CMP_SIZE: {
                return this.buildSizeComparator(builder, onId);
            }
        }
        throw new UnsupportedOperationException(this.cmpMode + " is currently not supported.");
    }

    private Dbfilters.ComparatorProto buildSizeComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString state = Dbfilters.SizeComparatorProto.newBuilder().setSize(this.value.getInt()).setOnIdField(onId).build().toByteString();
        return builder.setName("2e7025c4").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildPatternComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString pattern = ByteString.copyFrom((byte[])Bytes.toBytes((String)this.value.getString()));
        ByteString state = Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(pattern).setIsUTF8(true).setOnIdField(onId).build().toByteString();
        return builder.setName("e2d7ba40").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildTypeComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        ByteString state = Dbfilters.TypeComparatorProto.newBuilder().setType(this.value.getInt()).setOnIdField(onId).build().toByteString();
        return builder.setName("1e95fd6b").setSerializedComparator(state).build();
    }

    private Dbfilters.ComparatorProto buildValueComparator(Dbfilters.ComparatorProto.Builder builder, boolean onId) {
        String name = null;
        ByteString state = null;
        if (this.value == null) {
            name = "8543f5eb";
            state = Dbfilters.NullComparatorProto.newBuilder().build().toByteString();
        } else {
            ByteString comparable = null;
            if (onId) {
                name = "05f39865";
                comparable = ByteString.copyFrom((ByteBuffer)IdCodec.encode(this.value));
            } else if (this.value != null) {
                if (this.isIndex && !this.nonindexed) {
                    name = "05f39865";
                    boolean isAsc = false;
                    try {
                        isAsc = IndexFieldDesc.Order.Asc == this.indexTable.getIndexComponentOrder(this.fieldStr);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to get index component order", e);
                    }
                    ByteBuffer bb = IndexRowKeyEncoder.encodeComponent(this.value, !isAsc);
                    comparable = ByteString.copyFrom((byte[])bb.array(), (int)0, (int)bb.position());
                } else {
                    name = "45a94888";
                    Dbfilters.ConditionLeafFieldsProto defaultInstance = Dbfilters.ConditionLeafFieldsProto.getDefaultInstance();
                    DBDocumentImpl rec = new DBDocumentImpl();
                    rec.set(defaultInstance.getXField(), this.value);
                    SerializedFamilyInfo[] famInfo = RowcolCodec.encode(rec, Constants.DEFAULT_FAMILY_MAP);
                    assert (famInfo.length == 1);
                    assert (famInfo[0].getAction() == SerializationAction.SET);
                    comparable = ByteString.copyFrom((ByteBuffer)famInfo[0].getByteBuffer());
                }
            }
            state = Dbfilters.BinaryComparatorProto.newBuilder().setComparable(comparable).setOnIdField(onId).build().toByteString();
        }
        return builder.setName(name).setSerializedComparator(state).build();
    }

    private int getPartitionKeyIdx() {
        int nPartitionKeys = ((ConditionImpl)this.topLevelCondition).getPartitionKeys().size();
        String conditionFieldName = this.field.toString();
        for (int i = 0; i < nPartitionKeys; ++i) {
            IndexFieldDesc idesc = ((ConditionImpl)this.topLevelCondition).getPartitionKeys().get(i);
            String partitionKeyComponentName = ((IndexFieldDescImpl)idesc).getFieldPathStr();
            if (idesc.isFunctional()) {
                partitionKeyComponentName = "$" + i;
            }
            if (!partitionKeyComponentName.equals(conditionFieldName)) continue;
            return i;
        }
        return -1;
    }

    private boolean isOnPartitionKeyPrefix() {
        IndexFieldDesc idesc = ((ConditionImpl)this.topLevelCondition).getPartitionKeys().get(0);
        String firstPartitionKeyComponentName = ((IndexFieldDescImpl)idesc).getFieldPathStr();
        String conditionFieldName = this.field.toString();
        if (idesc.isFunctional()) {
            firstPartitionKeyComponentName = "$0";
        }
        return firstPartitionKeyComponentName.equals(conditionFieldName);
    }

    @Override
    List<List<ConditionNode.RowkeyRange>> getRowkeyRanges() {
        ConditionImpl topCond = (ConditionImpl)this.topLevelCondition;
        if (topCond.hasRowKeyCondition() && !this.isOnRowKey()) {
            return FULL_TABLE_RANGE_LIST;
        }
        return this.calculateRowKeyRange();
    }

    private List<List<ConditionNode.RowkeyRange>> calculateRowKeyRange() {
        List<List<ConditionNode.RowkeyRange>> llrr = this.getLLRR();
        int idx = this.getPartitionKeyIdx();
        if (this.op == Dbfilters.CompareOpProto.NOT_EQUAL || this.value == null || this.cmpMode != Dbfilters.ComparatorModeProto.CMP_VALUE && this.cmpMode != Dbfilters.ComparatorModeProto.CMP_PATTERN || !this.isOnRowKey() && idx < 0) {
            return llrr;
        }
        ConditionImpl topCond = (ConditionImpl)this.topLevelCondition;
        if (!this.isOnRowKey() && topCond.isSecondaryIndexQueryCondition()) {
            List<IndexFieldDesc> partitionKeys = topCond.getPartitionKeys();
            boolean[] descendingOrder = new boolean[partitionKeys.size()];
            for (int i = 0; i < partitionKeys.size(); ++i) {
                descendingOrder[i] = partitionKeys.get(i).getSortOrder() == IndexFieldDesc.Order.Desc;
            }
            boolean missingAndNullFirst = topCond.getMissingAndNullFirst();
            boolean isHashedIndex = topCond.isHashedIndexQueryCondition();
            int numHashPartitions = isHashedIndex ? topCond.getHashedIndexNumPartitions() : 0;
            IndexRowKeyEncoder encoder = new IndexRowKeyEncoder(descendingOrder, missingAndNullFirst, isHashedIndex, numHashPartitions);
            if (this.op == Dbfilters.CompareOpProto.EQUAL && this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
                byte[] regexPrefix = Regexes.getRegexPrefix((String)this.value.getString()).getBytes();
                llrr.set(idx, regexPrefix.length == 0 ? FULL_TABLE_RANGE : encoder.getRowKeyRangeForPrefixMatch(regexPrefix, idx));
            } else {
                llrr.set(idx, encoder.getRowKeyRange(this.op, this.value, idx));
            }
            return llrr;
        }
        llrr = new ArrayList<List<ConditionNode.RowkeyRange>>(1);
        llrr.add(FULL_TABLE_RANGE);
        byte[] startRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] fieldValue = null;
        if (this.field.equals((Object)Constants.ROWKEY_FIELD_PATH)) {
            assert (this.value.getType() == Value.Type.BINARY);
            fieldValue = Bytes.getBytes((ByteBuffer)this.value.getBinary());
        } else {
            fieldValue = IdCodec.encodeAsBytes(this.value);
        }
        switch (this.op) {
            case GREATER_OR_EQUAL: {
                startRow = fieldValue;
                break;
            }
            case GREATER: {
                startRow = Bytes.appendZeroByte((byte[])fieldValue);
                break;
            }
            case LESS_OR_EQUAL: {
                stopRow = Bytes.appendZeroByte((byte[])fieldValue);
                break;
            }
            case LESS: {
                stopRow = fieldValue;
                break;
            }
            case EQUAL: {
                if (this.cmpMode == Dbfilters.ComparatorModeProto.CMP_PATTERN) {
                    String prefix = Regexes.getRegexPrefix((String)this.value.getString());
                    if (prefix.length() <= 0 || (stopRow = Bytes.createStopKeyForPrefix((byte[])(startRow = Bytes.getBytes((ByteBuffer)IdCodec.encode(prefix))))).length <= startRow.length) break;
                    stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
                    break;
                }
                startRow = fieldValue;
                stopRow = Bytes.appendZeroByte((byte[])fieldValue);
            }
        }
        if (startRow != MapRConstants.EMPTY_BYTE_ARRAY || stopRow != MapRConstants.EMPTY_BYTE_ARRAY) {
            llrr.set(0, (List<ConditionNode.RowkeyRange>)ImmutableList.of((Object)new ConditionNode.RowkeyRange(startRow, stopRow)));
        }
        return llrr;
    }

    private String serializeBase64() {
        ConditionDescriptor condDesc = this.getDescriptor(Constants.DEFAULT_FAMILY_MAP, null);
        ByteBuffer condBuffer = condDesc.getSerialized();
        byte[] condBytes = new byte[condBuffer.limit() - condBuffer.position()];
        condBuffer.get(condBytes);
        String condString = base64UrlEncoder.encode(condBytes);
        return condString;
    }

    @Override
    void visit(ConditionVisitor visitor) {
        visitor.field(this.field);
        block0 : switch (this.cmpMode) {
            case CMP_VALUE: {
                Value.Type valueType = this.value == null ? Value.Type.NULL : this.value.getType();
                switch (valueType) {
                    case ARRAY: 
                    case MAP: {
                        visitor.stringLiteral(this.serializeBase64());
                        visitor.operator("ojai_condition", 2);
                        break block0;
                    }
                }
                this.visitValue(visitor);
                visitor.operator((QueryCondition.Op)opProtoMapInverse.get((Object)this.op), 2);
                break;
            }
            case CMP_PATTERN: {
                visitor.stringLiteral(this.value.getString());
                visitor.operator(this.op == Dbfilters.CompareOpProto.EQUAL ? "matches" : "notMatches", 2);
                break;
            }
            case CMP_TYPE: {
                visitor.operator("typeOf", 1);
                this.visitValue(visitor);
                visitor.operator((QueryCondition.Op)opProtoMapInverse.get((Object)this.op), 2);
                break;
            }
            case CMP_SIZE: {
                visitor.operator("sizeOf", 1);
                this.visitValue(visitor);
                visitor.operator((QueryCondition.Op)opProtoMapInverse.get((Object)this.op), 2);
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized comparator mode for ConditionLeaf");
            }
        }
    }

    private void visitValue(ConditionVisitor visitor) {
        Value.Type valueType = this.value == null ? Value.Type.NULL : this.value.getType();
        switch (valueType) {
            case ARRAY: {
                throw new RuntimeException("unimplemented");
            }
            case BINARY: {
                visitor.binaryLiteral(this.value.getBinary());
                break;
            }
            case BOOLEAN: {
                visitor.booleanLiteral(this.value.getBoolean());
                break;
            }
            case BYTE: {
                visitor.byteLiteral(this.value.getByte());
                break;
            }
            case DATE: {
                visitor.dateLiteral(this.value.getDate());
                break;
            }
            case DECIMAL: {
                visitor.decimalLiteral(this.value.getDecimal());
                break;
            }
            case DOUBLE: {
                visitor.doubleLiteral(this.value.getDouble());
                break;
            }
            case FLOAT: {
                visitor.floatLiteral(this.value.getFloat());
                break;
            }
            case INT: {
                visitor.intLiteral(this.value.getInt());
                break;
            }
            case INTERVAL: {
                visitor.intervalLiteral(this.value.getInterval());
                break;
            }
            case LONG: {
                visitor.longLiteral(this.value.getLong());
                break;
            }
            case MAP: {
                visitor.mapLiteral(this.value.getMap());
                break;
            }
            case NULL: {
                visitor.nullLiteral();
                break;
            }
            case SHORT: {
                visitor.shortLiteral(this.value.getShort());
                break;
            }
            case STRING: {
                visitor.stringLiteral(this.value.getString());
                break;
            }
            case TIME: {
                visitor.timeLiteral(this.value.getTime());
                break;
            }
            case TIMESTAMP: {
                visitor.timestampLiteral(this.value.getTimestamp());
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized value type " + this.value.getType());
            }
        }
    }

    @Override
    boolean hasRowKeyCondition() {
        return this.isOnRowKey();
    }
}

