/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.FamilyDescriptorImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.impl.index.IndexDescImpl;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.util.Fids;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.ojai.FieldPath;

public class AdminImplHelper {
    private final MapRFileSystem maprfs_;
    private final AdminImpl main_;
    public static final String SYSTEM_NAME = "maprdb";

    public AdminImplHelper(AdminImpl main, MapRFileSystem maprfs) {
        this.main_ = main;
        this.maprfs_ = maprfs;
    }

    String getFieldPath(Map<Integer, Dbserver.ColumnFamilyAttr> cfIdAttributesMap, Dbserver.SIndexInfo.FieldInfo fi) throws IOException {
        int cfId = fi.getFieldPathQualifier(0).getFamily();
        Dbserver.ColumnFamilyAttr cfAttr = cfIdAttributesMap.get(cfId);
        if (cfAttr == null) {
            throw new IOException("Could not find the column family with id " + cfId + " in table schema");
        }
        String jsonFamilyPath = cfAttr.getJsonFamilyPath();
        String remainingJsonPath = fi.getFieldPathQualifier(0).getQualifiers(0).toStringUtf8();
        if (cfId != 1) {
            String prefixToChop = "v.";
            remainingJsonPath = remainingJsonPath.substring("v.".length());
        }
        return jsonFamilyPath.isEmpty() ? remainingJsonPath : jsonFamilyPath + "." + remainingJsonPath;
    }

    Map<Integer, Dbserver.ColumnFamilyAttr> getPrimaryTableFamilies(Path primaryTablePath) throws IOException {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        List cfAttrs = this.maprfs_.listColumnFamily(primaryTablePath, false, true);
        for (Dbserver.ColumnFamilyAttr columnFamilyAttr : cfAttrs) {
            int cfId = columnFamilyAttr.getSchFamily().getId();
            builder.put((Object)cfId, (Object)columnFamilyAttr);
        }
        return builder.build();
    }

    Table _createTable(TableDescriptor tableDesc, byte[][] splitPoints, boolean openTable) throws DBException {
        try {
            if (this.maprfs_.exists(tableDesc.getPath())) {
                throw new TableExistsException(tableDesc.getPath());
            }
            if (splitPoints != null) {
                Arrays.sort(splitPoints, Bytes.BYTES_COMPARATOR);
            }
            TableDescriptorImpl descImpl = (TableDescriptorImpl)tableDesc;
            this.maprfs_.createTable(tableDesc.getPath(), null, descImpl.getTableAttr().build(), descImpl.getTableAces().build(), splitPoints, false, -1);
            if (tableDesc.getFamilies().isEmpty()) {
                this.maprfs_.createColumnFamily(tableDesc.getPath(), "default", FamilyDescriptorImpl.DEFAULT_COLUMN_FAMILY_ATTR);
            } else {
                int numFam = tableDesc.getNumFamilies();
                boolean isStream = ((TableDescriptorImpl)tableDesc).isStream();
                for (FamilyDescriptor family : tableDesc.getFamilies()) {
                    if (!isStream && numFam > 1 && family.getTTL() != 0L) {
                        this.main_.deleteTable(tableDesc.getPath());
                        throw new OpNotPermittedException("TLL cannot be set with multiple column families.");
                    }
                    this.maprfs_.createColumnFamily(tableDesc.getPath(), family.getName(), this.getColumnFamilyAttr(false, family.getName(), family));
                }
            }
            return openTable ? new MapRDBTableImpl(this.maprfs_.getConf(), tableDesc.getPath()) : null;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "createTable()");
        }
    }

    Dbserver.ColumnFamilyAttr getColumnFamilyAttr(boolean forAlter, String familyName, FamilyDescriptor familyDesc) {
        FamilyDescriptorImpl familyDescImpl = (FamilyDescriptorImpl)familyDesc;
        Dbserver.SchemaFamily.Builder schemaFamily = familyDescImpl.getSchemaFamily();
        schemaFamily.clearId();
        if (familyName == null || familyDesc.getName().equals(familyName)) {
            schemaFamily.clearName();
        }
        Dbserver.ColumnFamilyAttr.Builder builder = Dbserver.ColumnFamilyAttr.newBuilder();
        FieldPath jsonFamilyPath = familyDescImpl.getJsonFieldPath();
        if (!forAlter && jsonFamilyPath != null && !jsonFamilyPath.equals((Object)FieldPath.EMPTY)) {
            builder.setJsonFamilyPath(jsonFamilyPath.asPathString());
        }
        return builder.setSchFamily(schemaFamily).build();
    }

    public Collection<IndexDesc> getTableIndexes(Path tablePath, boolean refreshNow) {
        try {
            Map<Integer, Dbserver.ColumnFamilyAttr> cfIdAttributesMap = this.getPrimaryTableFamilies(tablePath);
            LinkedList<IndexDesc> indexList = new LinkedList<IndexDesc>();
            Dbserver.TableReplicaListResponse resp = this.maprfs_.listTableIndexes(tablePath, false, false, refreshNow);
            for (Dbserver.TableReplicaDesc rd : resp.getReplicasList()) {
                String fieldPath;
                if (rd.getRstate() != Dbserver.TableReplicaState.REPLICA_STATE_REPLICATING) continue;
                Dbserver.SIndexInfo siInfo = rd.getSiInfo();
                boolean isHashed = siInfo.getHashed();
                int numHashPartitions = isHashed ? siInfo.getHashingInfo().getHashConfig(0).getNumPartitions() : 0;
                IndexDescImpl.Builder indexDescBuilder = new IndexDescImpl.Builder().setSystemName(SYSTEM_NAME).setPrimaryTablePath(tablePath).setIndexFid(Fids.fidToString((Common.FidMsg)siInfo.getIndexFid())).setIndexName(siInfo.getIndexName()).setIndexName(siInfo.getIndexName()).setSIndexInfo(siInfo).setHashed(isHashed, numHashPartitions).setFullIndex(siInfo.getIsFullIndex());
                for (Dbserver.SIndexInfo.FieldInfo fi : siInfo.getIndexedFieldsList()) {
                    IndexFieldDesc.Order order;
                    fieldPath = null;
                    boolean isUpdateTimestamp = false;
                    int fieldPathIdx = 0;
                    if (fi.hasUpdateTimestamp() && fi.getUpdateTimestamp()) {
                        isUpdateTimestamp = true;
                        fieldPath = "$$timestamp";
                    } else {
                        fieldPath = this.getFieldPath(cfIdAttributesMap, fi);
                        fieldPathIdx = fi.getFieldPathIdx(0);
                    }
                    IndexFieldDesc.Order order2 = order = fi.getSortOrder() == Dbserver.SIndexInfo.SIndexOrder.ASC ? IndexFieldDesc.Order.Asc : IndexFieldDesc.Order.Desc;
                    IndexFieldDescImpl indexFieldDesc = fi.getMapInfo().getType() != Dbserver.SIndexInfo.MappingType.NONE ? (fi.getMapInfo().getCastType() == Dbserver.SIndexInfo.CastType.STRING ? new IndexFieldDescImpl(fieldPath, fieldPathIdx, order, true, isUpdateTimestamp, new String(fi.getMapInfo().getType() + " AS " + fi.getMapInfo().getCastType() + "(" + (fi.getMapInfo().getCastStringLength() - 1) + ")")) : new IndexFieldDescImpl(fieldPath, fieldPathIdx, order, true, isUpdateTimestamp, new String(fi.getMapInfo().getType() + " AS " + fi.getMapInfo().getCastType()))) : new IndexFieldDescImpl(fieldPath, fieldPathIdx, order, false, isUpdateTimestamp, null);
                    indexDescBuilder.addIndexedField(indexFieldDesc);
                }
                for (Dbserver.SIndexInfo.FieldInfo fi : siInfo.getNonindexedFieldsList()) {
                    fieldPath = this.getFieldPath(cfIdAttributesMap, fi);
                    int fieldPathIdx = fi.getFieldPathIdx(0);
                    IndexFieldDescImpl indexFieldDesc = new IndexFieldDescImpl(fieldPath, fieldPathIdx, IndexFieldDesc.Order.None, false, false, null);
                    indexDescBuilder.addIncludedFields(indexFieldDesc);
                }
                indexList.add(indexDescBuilder.build());
            }
            return indexList;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getTableIndexes()");
        }
    }
}

