/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db;

import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexDesc;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;

@API.Public
public class MapRDB {
    public static boolean tableExists(String tablePath) throws DBException {
        return MapRDBImpl.tableExists(tablePath);
    }

    public static Table createTable(String tablePath) throws DBException {
        return MapRDBImpl.createTable(tablePath);
    }

    public static boolean deleteTable(String tablePath) throws DBException {
        return MapRDBImpl.deleteTable(tablePath);
    }

    public static Table getTable(String pathName) throws DBException {
        return MapRDBImpl.getTable(pathName);
    }

    public static Table getTable(Path path) throws DBException {
        return MapRDBImpl.getTable(path);
    }

    public static Table getTable(Configuration conf, Path path) throws DBException {
        return MapRDBImpl.getTable(conf, path);
    }

    public static Table getIndexTable(Path primaryTablePath, IndexDesc indexDesc) throws DBException {
        return MapRDBImpl.getIndexTable(indexDesc);
    }

    public static Table getIndexTable(Path primaryTablePath, String indexFid, String indexName) throws DBException {
        return MapRDBImpl.getIndexTable(primaryTablePath, indexFid, indexName);
    }

    @Deprecated
    public static Admin getAdmin(Configuration conf) {
        return MapRDBImpl.getAdmin(conf);
    }

    public static Admin newAdmin() throws DBException {
        return MapRDBImpl.newAdmin();
    }

    public static Admin newAdmin(Configuration c) throws DBException {
        return MapRDBImpl.newAdmin();
    }

    public static TableDescriptor newTableDescriptor() {
        return MapRDBImpl.newTableDescriptor();
    }

    public static TableDescriptor newTableDescriptor(String tablePath) {
        return MapRDBImpl.newTableDescriptor(tablePath);
    }

    public static TableDescriptor newTableDescriptor(Path tablePath) {
        return MapRDBImpl.newTableDescriptor(tablePath);
    }

    public static FamilyDescriptor newFamilyDescriptor() {
        return MapRDBImpl.newDefaultFamilyDescriptor();
    }

    public static FamilyDescriptor newDefaultFamilyDescriptor() {
        return MapRDBImpl.newDefaultFamilyDescriptor();
    }

    public static FamilyDescriptor newFamilyDescriptor(String familyName, String jsonPath) {
        return MapRDBImpl.newFamilyDescriptor(familyName, jsonPath);
    }

    public static FamilyDescriptor newFamilyDescriptor(String familyName, FieldPath jsonPath) {
        return MapRDBImpl.newFamilyDescriptor(familyName, jsonPath);
    }

    public static Document newDocument() {
        return MapRDBImpl.newDocument();
    }

    public static Document newDocument(String jsonString) throws DecodingException {
        return MapRDBImpl.newDocument(jsonString);
    }

    public static Document newDocument(Map<String, Object> map) throws DecodingException {
        return MapRDBImpl.newDocument(map);
    }

    public static Document newDocument(Object bean) throws DecodingException {
        return MapRDBImpl.newDocument(bean);
    }

    public static DocumentBuilder newDocumentBuilder() {
        return MapRDBImpl.newDocumentBuilder();
    }

    public static DocumentMutation newMutation() {
        return MapRDBImpl.newMutation();
    }

    public static QueryCondition newCondition() {
        return MapRDBImpl.newCondition();
    }

    private MapRDB() {
    }
}

