/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestThreatHuntingFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestThreatHuntingFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testPunctuationPattern() throws Exception {
        String query = "SELECT punctuation_pattern('192.168.1.1 - - [10/Oct/2020:12:32:27 +0000] \"GET /some/web/app?param=test&param2=another_test\" 200 9987') AS pp FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"pp"}).baselineValues(new Object[]{"..._-_-_[//:::_+]_\"_///?=&=_\"__"}).go();
    }

    @Test
    public void testEmptyPunctuationPattern() throws Exception {
        String query = "SELECT punctuation_pattern('') AS pp FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"pp"}).baselineValues(new Object[]{""}).go();
    }

    @Test
    public void testEntropyFunction() throws Exception {
        String query = "SELECT entropy('asdkjflkdsjlefjdc') AS entropy FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"entropy"}).baselineValues(new Object[]{3.057476076289932}).go();
    }

    @Test
    public void testEntropyFunctionWithEmptyString() throws Exception {
        String query = "SELECT entropy('') AS entropy FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"entropy"}).baselineValues(new Object[]{0.0}).go();
    }

    @Test
    public void testNormedEntropyFunction() throws Exception {
        String query = "SELECT entropy_per_byte('asdkjflkdsjlefjdc') AS entropy FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"entropy"}).baselineValues(new Object[]{0.17985153389940778}).go();
    }

    @Test
    public void testNormedEntropyFunctionWithEmptyString() throws Exception {
        String query = "SELECT entropy_per_byte('') AS entropy FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"entropy"}).baselineValues(new Object[]{0.0}).go();
    }
}

