/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestStringDistanceFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestStringDistanceFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testCosineDistance() throws Exception {
        double result = this.queryBuilder().sql("select cosine_distance( 'Big car', 'red car' ) as distance FROM (VALUES(1))").singletonDouble();
        Assert.assertEquals((double)0.5000000000000001, (double)result, (double)0.0);
    }

    @Test
    public void testHammingDistance() throws Exception {
        double result = this.queryBuilder().sql("select hamming_distance( 'Big car', 'red car' ) as distance FROM (VALUES(1))").singletonDouble();
        Assert.assertEquals((double)3.0, (double)result, (double)0.0);
    }

    @Test
    public void testJaccardDistance() throws Exception {
        double result = this.queryBuilder().sql("select jaccard_distance( 'Big car', 'red car' ) as distance FROM (VALUES(1))").singletonDouble();
        Assert.assertEquals((double)0.5555555555555556, (double)result, (double)0.0);
    }

    @Test
    public void testJaroDistance() throws Exception {
        double result = this.queryBuilder().sql("select jaro_distance( 'Big car', 'red car' ) as distance FROM (VALUES(1))").singletonDouble();
        Assert.assertEquals((double)0.2857142857142857, (double)result, (double)0.0);
    }

    @Test
    public void testLevenshteinDistance() throws Exception {
        double result = this.queryBuilder().sql("select levenshtein_distance( 'Big car', 'red car' ) as distance FROM (VALUES(1))").singletonDouble();
        Assert.assertEquals((double)3.0, (double)result, (double)0.0);
    }
}

