/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import java.time.LocalDateTime;
import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestTimeBucketFunction
extends ClusterTest {
    private static final long MILLISECOND_TIMESTAMP = 1451606760L;
    private static final long NAMOSECOND_TIMESTAMP = 1451606760000000000L;
    private static final long MARCH27_TIMESTAMP = 1585272833845L;
    private static final int INTERVAL = 300000;

    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestTimeBucketFunction.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testTimeBucketNanoSeconds() throws Exception {
        String query = String.format("SELECT time_bucket_ns(%d, %d) AS high", 1451606760000000000L, 300000);
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{1451606700000000000L}).go();
    }

    @Test
    public void testNullTimeBucketNanoSeconds() throws Exception {
        String query = String.format("SELECT time_bucket_ns(null, %d) AS high", 300000);
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testNullIntervalTimeBucketNanoSeconds() throws Exception {
        String query = String.format("SELECT time_bucket_ns(%d, null) AS high", 1451606760000000000L);
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testBothNullIntervalTimeBucketNanoSeconds() throws Exception {
        String query = "SELECT time_bucket_ns(null, null) AS high";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testTimeBucket() throws Exception {
        String query = String.format("SELECT time_bucket(%d, 300000) AS high", 1451606760L);
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{1451400000L}).go();
    }

    @Test
    public void testDoubleTimeBucket() throws Exception {
        String query = String.format("SELECT time_bucket(CAST(%d AS DOUBLE), 300000) AS high", 1451606760L);
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{1451400000L}).go();
    }

    @Test
    public void testTimeBucketTimestamp() throws Exception {
        String query = String.format("SELECT time_bucket(CAST( %d AS TIMESTAMP), 300000) AS high", 1585272833845L);
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{LocalDateTime.of(2020, 3, 27, 1, 30, 0)}).go();
    }

    @Test
    public void testNullTimeBucket() throws Exception {
        String query = String.format("SELECT time_bucket(null, %d) AS high", 300000);
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testNullIntervalTimeBucket() throws Exception {
        String query = String.format("SELECT time_bucket(%d, null) AS high", 1451606760L);
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testBothNullIntervalTimeBucket() throws Exception {
        String query = "SELECT time_bucket(null, null) AS high";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"high"}).baselineValues(new Object[]{null}).go();
    }
}

